/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dal;

import lombok.Generated;
import org.apache.shardingsphere.encrypt.merge.dal.show.EncryptShowColumnsMergedResult;
import org.apache.shardingsphere.encrypt.merge.dal.show.EncryptShowCreateTableMergedResult;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.merge.engine.decorator.ResultDecorator;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLExplainStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLShowColumnsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLShowCreateTableStatement;

public final class EncryptDALResultDecorator
implements ResultDecorator<EncryptRule> {
    private final RuleMetaData globalRuleMetaData;

    public MergedResult decorate(MergedResult mergedResult, SQLStatementContext sqlStatementContext, EncryptRule rule) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof MySQLExplainStatement || sqlStatement instanceof MySQLShowColumnsStatement) {
            return new EncryptShowColumnsMergedResult(mergedResult, sqlStatementContext, rule);
        }
        if (sqlStatement instanceof MySQLShowCreateTableStatement) {
            return new EncryptShowCreateTableMergedResult(this.globalRuleMetaData, mergedResult, sqlStatementContext, rule);
        }
        return mergedResult;
    }

    @Generated
    public EncryptDALResultDecorator(RuleMetaData globalRuleMetaData) {
        this.globalRuleMetaData = globalRuleMetaData;
    }
}

