/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.codegen;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.servicecomb.toolkit.codegen.AbstractMultiDirectoryStrategy;
import org.apache.servicecomb.toolkit.codegen.ServiceType;
import org.openapitools.codegen.SupportingFile;

public class DefaultDirectoryStrategy
extends AbstractMultiDirectoryStrategy {
    protected String providerTemplateFolder = "provider";
    private String consumerTemplateFolder = "consumer";
    private String apiConsumerTemplate = this.consumerTemplateFolder + "/apiConsumer.mustache";
    private String apiConsumerTemplateForPojo = this.consumerTemplateFolder + "/pojo/apiConsumer.mustache";
    private String apiInterfaceTemplateForPojo = this.consumerTemplateFolder + "/pojo/apiInterface.mustache";

    @Override
    public String modelDirectory() {
        return Optional.ofNullable((String)this.propertiesMap.get("modelProjectName")).orElse("model");
    }

    @Override
    public String providerDirectory() {
        return Optional.ofNullable((String)this.propertiesMap.get("providerProjectName")).orElse("provider");
    }

    @Override
    public String consumerDirectory() {
        return Optional.ofNullable((String)this.propertiesMap.get("consumerProjectName")).orElse("consumer");
    }

    @Override
    public void processSupportingFile(List<SupportingFile> supportingFiles) {
        super.processSupportingFile(supportingFiles);
        this.processProvider(supportingFiles);
        this.processConsumer(supportingFiles);
        this.processModel(supportingFiles);
        this.processParentProjectOpts(supportingFiles);
        this.propertiesMap.put("isMultipleModule", true);
    }

    private void processParentProjectOpts(List<SupportingFile> supportingFiles) {
        supportingFiles.add(new SupportingFile("project/pom.mustache", "", "pom.xml"));
    }

    private void processModel(List<SupportingFile> supportingFiles) {
        this.propertiesMap.computeIfAbsent("modelArtifactId", k -> this.modelDirectory());
        supportingFiles.add(new SupportingFile("model/pom.mustache", this.modelDirectory(), "pom.xml"));
    }

    private void processConsumer(List<SupportingFile> supportingFiles) {
        String newConsumerTemplateFolder = this.consumerTemplateFolder;
        if ("SpringBoot".equals(this.propertiesMap.get("library"))) {
            newConsumerTemplateFolder = newConsumerTemplateFolder + "/springboot";
        }
        supportingFiles.add(new SupportingFile(newConsumerTemplateFolder + "/pom.mustache", this.consumerDirectory(), "pom.xml"));
        supportingFiles.add(new SupportingFile(newConsumerTemplateFolder + "/Application.mustache", this.mainClassFolder(this.consumerDirectory()), "Application.java"));
        supportingFiles.add(new SupportingFile("log4j2.mustache", this.resourcesFolder(this.consumerDirectory()), "log4j2.xml"));
        supportingFiles.add(new SupportingFile(this.consumerTemplateFolder + "/microservice.mustache", this.resourcesFolder(this.consumerDirectory()), "microservice.yaml"));
        this.propertiesMap.computeIfAbsent("consumerArtifactId", k -> this.consumerDirectory());
        this.propertiesMap.put(this.apiConsumerTemplate, ServiceType.CONSUMER.getValue());
        Map apiTemplateFiles = (Map)this.propertiesMap.get("apiTemplateFiles");
        if ("POJO".equals(this.propertiesMap.get("library"))) {
            apiTemplateFiles.put(this.apiConsumerTemplateForPojo, "Consumer.java");
            this.propertiesMap.put(this.apiConsumerTemplateForPojo, ServiceType.CONSUMER.getValue());
            apiTemplateFiles.put(this.apiInterfaceTemplateForPojo, ".java");
            this.propertiesMap.put(this.apiInterfaceTemplateForPojo, ServiceType.CONSUMER.getValue());
            this.propertiesMap.put("isPOJO", true);
        } else {
            apiTemplateFiles.put(this.apiConsumerTemplate, ".java");
        }
    }

    private void processProvider(List<SupportingFile> supportingFiles) {
        supportingFiles.add(new SupportingFile("pom.mustache", this.providerDirectory(), "pom.xml"));
        supportingFiles.add(new SupportingFile("Application.mustache", this.mainClassFolder(this.providerDirectory()), "Application.java"));
        supportingFiles.add(new SupportingFile("log4j2.mustache", this.resourcesFolder(this.providerDirectory()), "log4j2.xml"));
        supportingFiles.add(new SupportingFile(this.providerTemplateFolder + "/microservice.mustache", this.resourcesFolder(this.providerDirectory()), "microservice.yaml"));
        this.propertiesMap.computeIfAbsent("providerArtifactId", k -> this.providerDirectory());
        if ("POJO".equals(this.propertiesMap.get("library"))) {
            this.propertiesMap.put("isPOJO", true);
        }
    }
}

