/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.codegen;

import java.util.List;
import java.util.Map;
import org.apache.servicecomb.toolkit.codegen.AbstractConsumerDirectoryStrategy;
import org.openapitools.codegen.SupportingFile;

public class ConsumerDirectoryStrategy
extends AbstractConsumerDirectoryStrategy {
    private String consumerTemplateFolder = "consumer";
    private String apiConsumerTemplate = this.consumerTemplateFolder + "/apiConsumer.mustache";
    private String apiConsumerTemplateForPojo = this.consumerTemplateFolder + "/pojo/apiConsumer.mustache";
    private String apiInterfaceTemplateForPojo = this.consumerTemplateFolder + "/pojo/apiInterface.mustache";

    @Override
    public String modelDirectory() {
        return this.consumerDirectory();
    }

    @Override
    public String providerDirectory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String consumerDirectory() {
        return (String)this.propertiesMap.get("artifactId");
    }

    @Override
    public void processSupportingFile(List<SupportingFile> supportingFiles) {
        super.processSupportingFile(supportingFiles);
        String newConsumerTemplateFolder = this.consumerTemplateFolder;
        if ("SpringBoot".equals(this.propertiesMap.get("library"))) {
            newConsumerTemplateFolder = newConsumerTemplateFolder + "/springboot";
        }
        supportingFiles.add(new SupportingFile(newConsumerTemplateFolder + "/pom.mustache", this.consumerDirectory(), "pom.xml"));
        supportingFiles.add(new SupportingFile(newConsumerTemplateFolder + "/Application.mustache", this.mainClassFolder(this.consumerDirectory()), "Application.java"));
        supportingFiles.add(new SupportingFile("log4j2.mustache", this.resourcesFolder(this.consumerDirectory()), "log4j2.xml"));
        supportingFiles.add(new SupportingFile(this.consumerTemplateFolder + "/microservice.mustache", this.resourcesFolder(this.consumerDirectory()), "microservice.yaml"));
        this.propertiesMap.computeIfAbsent("consumerArtifactId", k -> this.propertiesMap.get("artifactId"));
        this.propertiesMap.put("apiConsumerTemplate", this.apiConsumerTemplate);
        this.propertiesMap.put("apiConsumerTemplateForPojo", this.apiConsumerTemplateForPojo);
        Map apiTemplateFiles = (Map)this.propertiesMap.get("apiTemplateFiles");
        apiTemplateFiles.remove("api.mustache");
        if ("POJO".equals(this.propertiesMap.get("library"))) {
            apiTemplateFiles.put(this.apiConsumerTemplateForPojo, "Consumer.java");
            apiTemplateFiles.put(this.apiInterfaceTemplateForPojo, ".java");
            this.propertiesMap.put("isPOJO", true);
        } else {
            apiTemplateFiles.put(this.apiConsumerTemplate, ".java");
        }
    }
}

