/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.cli;

import io.airlift.airline.Cli;
import io.airlift.airline.Help;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.toolkit.cli.CheckCompatibility;
import org.apache.servicecomb.toolkit.cli.CheckCompatibilityAbbr;
import org.apache.servicecomb.toolkit.cli.CheckStyle;
import org.apache.servicecomb.toolkit.cli.CheckStyleAbbr;
import org.apache.servicecomb.toolkit.cli.CodeGenerate;
import org.apache.servicecomb.toolkit.cli.DocGenerate;
import org.apache.servicecomb.toolkit.cli.ValidationFailedException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ToolkitMain {
    private static String projectVersion;

    public static void main(String[] args) {
        ToolkitMain.initialProjectVersion();
        String scriptName = System.getProperty("script.name");
        Cli.CliBuilder builder = null;
        builder = StringUtils.isNotEmpty((CharSequence)scriptName) ? Cli.builder((String)scriptName) : Cli.builder((String)("java -jar cli-" + projectVersion + ".jar"));
        builder.withDescription("Microservice development toolkit(version " + projectVersion + "). ");
        builder.withDefaultCommand(Help.class);
        builder.withCommands(CodeGenerate.class, new Class[]{DocGenerate.class, CheckStyle.class, CheckStyleAbbr.class, CheckCompatibility.class, CheckCompatibilityAbbr.class, Help.class});
        try {
            Runnable cmd = (Runnable)builder.build().parse(args);
            cmd.run();
        }
        catch (ValidationFailedException ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static void initialProjectVersion() {
        Properties properties = new Properties();
        try {
            properties.load(ToolkitMain.class.getClassLoader().getResourceAsStream("application.properties"));
            projectVersion = Optional.ofNullable(properties.getProperty("version")).orElse("unknown");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

