/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.compatibility.validators.schema;

import io.swagger.v3.oas.models.media.Schema;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.compatibility.validators.schema.TypeFormat;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffValidationContext;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffViolation;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.SchemaCompareValidator;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.util.ChangeRangeCheckUtils;

public abstract class SchemaTypeFormatChangeValidator
implements SchemaCompareValidator {
    public final List<OasDiffViolation> validate(OasDiffValidationContext context, OasObjectPropertyLocation leftLocation, Schema leftOasObject, OasObjectPropertyLocation rightLocation, Schema rightOasObject) {
        if (!this.needValidate(context)) {
            return Collections.emptyList();
        }
        TypeFormat leftTypeFormat = new TypeFormat(leftOasObject);
        TypeFormat rightTypeFormat = new TypeFormat(rightOasObject);
        if (ChangeRangeCheckUtils.isNotViolated((Object)leftTypeFormat, (Object)rightTypeFormat, this.getAllowedChangedList())) {
            return Collections.emptyList();
        }
        StringBuilder message = new StringBuilder("the change ");
        message.append("(type=").append(leftTypeFormat.getType()).append(",format=").append(leftTypeFormat.getFormat()).append(')').append("->").append("(type=").append(rightTypeFormat.getType()).append(",format=").append(rightTypeFormat.getFormat()).append(')').append(" is not allowed");
        return Collections.singletonList(new OasDiffViolation(leftLocation, rightLocation, message.toString()));
    }

    protected abstract List<Object[]> getAllowedChangedList();

    protected abstract boolean needValidate(OasDiffValidationContext var1);
}

