/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.compatibility.validators.schema;

import io.swagger.v3.oas.models.media.Schema;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffValidationContext;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffViolation;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.SchemaCompareValidator;

public abstract class SchemaPropertyChangeValidator<T>
implements SchemaCompareValidator {
    public final List<OasDiffViolation> validate(OasDiffValidationContext context, OasObjectPropertyLocation leftLocation, Schema leftOasObject, OasObjectPropertyLocation rightLocation, Schema rightOasObject) {
        T rightNumber;
        if (!this.needValidate(context)) {
            return Collections.emptyList();
        }
        T leftNumber = this.getProperty(leftOasObject);
        if (Objects.equals(leftNumber, rightNumber = this.getProperty(rightOasObject))) {
            return Collections.emptyList();
        }
        String propertyName = this.getPropertyName();
        if (leftNumber == null || rightNumber == null) {
            return Collections.singletonList(new OasDiffViolation(leftLocation.property(propertyName), rightLocation.property(propertyName), this.getMessage(leftNumber, rightNumber)));
        }
        if (!this.isAllowed(leftNumber, rightNumber)) {
            return Collections.singletonList(new OasDiffViolation(leftLocation.property(propertyName), rightLocation.property(propertyName), this.getMessage(leftNumber, rightNumber)));
        }
        return Collections.emptyList();
    }

    protected abstract T getProperty(Schema var1);

    protected abstract String getPropertyName();

    protected abstract String getMessage(T var1, T var2);

    protected abstract boolean isAllowed(T var1, T var2);

    protected abstract boolean needValidate(OasDiffValidationContext var1);
}

