/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialPartitioning;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.sedona.core.enums.GridType;
import org.apache.sedona.core.spatialPartitioning.FlatGridPartitioner;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.strtree.STRtree;
import scala.Tuple2;

public class IndexedGridPartitioner
extends FlatGridPartitioner {
    private final STRtree index = new STRtree();

    public IndexedGridPartitioner(GridType gridType, List<Envelope> grids, Boolean preserveUncontainedGeometries) {
        super(gridType, grids, preserveUncontainedGeometries);
        for (int i = 0; i < grids.size(); ++i) {
            Envelope grid = grids.get(i);
            this.index.insert(grid, (Object)i);
        }
        this.index.build();
    }

    public IndexedGridPartitioner(GridType gridType, List<Envelope> grids) {
        this(gridType, grids, true);
    }

    public IndexedGridPartitioner(List<Envelope> grids, Boolean preserveUncontainedGeometries) {
        this(null, grids, preserveUncontainedGeometries);
    }

    public IndexedGridPartitioner(List<Envelope> grids) {
        this(null, grids);
    }

    public STRtree getIndex() {
        return this.index;
    }

    @Override
    public Iterator<Tuple2<Integer, Geometry>> placeObject(Geometry spatialObject) throws Exception {
        List results = this.index.query(spatialObject.getEnvelopeInternal());
        if (this.preserveUncontainedGeometries.booleanValue()) {
            int overflowContainerID = this.grids.size();
            Envelope envelope = spatialObject.getEnvelopeInternal();
            HashSet<Tuple2> result = new HashSet<Tuple2>();
            boolean containFlag = false;
            for (Object queryResult : results) {
                Integer i2 = (Integer)queryResult;
                Envelope grid = (Envelope)this.grids.get(i2);
                if (grid.covers(envelope)) {
                    result.add(new Tuple2((Object)i2, (Object)spatialObject));
                    containFlag = true;
                    continue;
                }
                if (!grid.intersects(envelope)) continue;
                result.add(new Tuple2((Object)i2, (Object)spatialObject));
            }
            if (!containFlag) {
                result.add(new Tuple2((Object)overflowContainerID, (Object)spatialObject));
            }
            return result.iterator();
        }
        return results.stream().map(i -> new Tuple2(i, (Object)spatialObject)).iterator();
    }
}

