/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.optimization;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression$;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.execution.datasource.stac.TemporalFilter;
import org.apache.spark.sql.execution.datasource.stac.TemporalFilter$AndFilter$;
import org.apache.spark.sql.execution.datasources.DataSourceStrategy$;
import org.apache.spark.sql.execution.datasources.PushableColumn$;
import org.apache.spark.sql.execution.datasources.PushableColumnBase;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetSpatialFilter$AndFilter$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanRelation;
import org.apache.spark.sql.sedona_sql.io.stac.StacScan;
import org.apache.spark.sql.sedona_sql.optimization.ExpressionUtils$;
import org.apache.spark.sql.sedona_sql.optimization.SpatialFilterPushDownForGeoParquet;
import org.apache.spark.sql.sedona_sql.optimization.SpatialTemporalFilterPushDownForStacScan$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005y4A\u0001C\u0005\u0001-!A1\u0004\u0001B\u0001B\u0003%A\u0004C\u0003!\u0001\u0011\u0005\u0011\u0005C\u0003%\u0001\u0011\u0005S\u0005C\u00033\u0001\u0011%1\u0007C\u0003G\u0001\u0011\u0005q\tC\u0003f\u0001\u0011%a\rC\u0003s\u0001\u0011%1O\u0001\u0015Ta\u0006$\u0018.\u00197UK6\u0004xN]1m\r&dG/\u001a:QkNDGi\\<o\r>\u00148\u000b^1d'\u000e\fgN\u0003\u0002\u000b\u0017\u0005aq\u000e\u001d;j[&T\u0018\r^5p]*\u0011A\"D\u0001\u000bg\u0016$wN\\1`gFd'B\u0001\b\u0010\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003!E\tQa\u001d9be.T!AE\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0012aA8sO\u000e\u00011C\u0001\u0001\u0018!\tA\u0012$D\u0001\n\u0013\tQ\u0012B\u0001\u0012Ta\u0006$\u0018.\u00197GS2$XM\u001d)vg\"$un\u001e8G_J<Um\u001c)beF,X\r^\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003;yi\u0011!D\u0005\u0003?5\u0011Ab\u00159be.\u001cVm]:j_:\fa\u0001P5oSRtDC\u0001\u0012$!\tA\u0002\u0001C\u0003\u001c\u0005\u0001\u0007A$A\u0003baBd\u0017\u0010\u0006\u0002'aA\u0011qEL\u0007\u0002Q)\u0011\u0011FK\u0001\bY><\u0017nY1m\u0015\tYC&A\u0003qY\u0006t7O\u0003\u0002.\u001b\u0005A1-\u0019;bYf\u001cH/\u0003\u00020Q\tYAj\\4jG\u0006d\u0007\u000b\\1o\u0011\u0015\t4\u00011\u0001'\u0003\u0011\u0001H.\u00198\u0002%%\u001c8\u000b^1d'\u000e\fgNU3mCRLwN\u001c\u000b\u0003ii\u0002\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012qAQ8pY\u0016\fg\u000eC\u0003<\t\u0001\u0007A(\u0001\u0002meB\u0011Q\bR\u0007\u0002})\u0011q\bQ\u0001\u0003mJR!!\u0011\"\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003\u00076\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005\u0015s$\u0001\u0007#bi\u0006\u001cv.\u001e:dKZ\u00134kY1o%\u0016d\u0017\r^5p]\u0006QBO]1og2\fG/\u001a+p)\u0016l\u0007o\u001c:bY\u001aKG\u000e^3sgR\u0011\u0001\n\u0018\t\u0004\u0013F#fB\u0001&P\u001d\tYe*D\u0001M\u0015\tiU#\u0001\u0004=e>|GOP\u0005\u0002o%\u0011\u0001KN\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00116KA\u0002TKFT!\u0001\u0015\u001c\u0011\u0005USV\"\u0001,\u000b\u0005]C\u0016\u0001B:uC\u000eT!!\u0017\"\u0002\u0015\u0011\fG/Y:pkJ\u001cW-\u0003\u0002\\-\nqA+Z7q_J\fGNR5mi\u0016\u0014\b\"B/\u0006\u0001\u0004q\u0016A\u00039sK\u0012L7-\u0019;fgB\u0019\u0011*U0\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\td\u0013aC3yaJ,7o]5p]NL!\u0001Z1\u0003\u0015\u0015C\bO]3tg&|g.A\rue\u0006t7\u000f\\1uKR{G+Z7q_J\fGNR5mi\u0016\u0014HcA4kYB\u0019Q\u0007\u001b+\n\u0005%4$AB(qi&|g\u000eC\u0003l\r\u0001\u0007q,A\u0005qe\u0016$\u0017nY1uK\")QN\u0002a\u0001]\u0006q\u0001/^:iC\ndWmQ8mk6t\u0007CA8q\u001b\u0005\u0001\u0015BA9A\u0005I\u0001Vo\u001d5bE2,7i\u001c7v[:\u0014\u0015m]3\u0002\u000fUt\u0017/^8uKR\u0011A\u000f \t\u0003kft!A^<\u0011\u0005-3\u0014B\u0001=7\u0003\u0019\u0001&/\u001a3fM&\u0011!p\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a4\u0004\"B?\b\u0001\u0004!\u0018\u0001\u00028b[\u0016\u0004")
public class SpatialTemporalFilterPushDownForStacScan
extends SpatialFilterPushDownForGeoParquet {
    private final SparkSession sparkSession;

    @Override
    public LogicalPlan apply(LogicalPlan plan) {
        boolean enableSpatialFilterPushDown = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(this.sparkSession.conf().get("spark.sedona.stac.spatialFilterPushDown", "true")));
        if (!enableSpatialFilterPushDown) {
            return plan;
        }
        return (LogicalPlan)plan.transform((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialTemporalFilterPushDownForStacScan $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Filter) {
                    DataSourceV2ScanRelation dataSourceV2ScanRelation;
                    Filter filter = (Filter)A1;
                    Expression condition = filter.condition();
                    LogicalPlan lr = filter.child();
                    if (lr instanceof DataSourceV2ScanRelation && this.$outer.org$apache$spark$sql$sedona_sql$optimization$SpatialTemporalFilterPushDownForStacScan$$isStacScanRelation(dataSourceV2ScanRelation = (DataSourceV2ScanRelation)lr)) {
                        BoxedUnit boxedUnit;
                        BoxedUnit boxedUnit2;
                        Seq<Expression> filters = ExpressionUtils$.MODULE$.splitConjunctivePredicates(condition);
                        Seq normalizedFilters = DataSourceStrategy$.MODULE$.normalizeExprs(filters, dataSourceV2ScanRelation.output());
                        Tuple2 tuple2 = normalizedFilters.partition((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)$anonfun$apply$1.$anonfun$applyOrElse$1(e)));
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Seq normalizedFiltersWithoutSubquery = (Seq)tuple2._2();
                        Seq normalizedFiltersWithoutSubquery2 = normalizedFiltersWithoutSubquery;
                        Seq<GeoParquetSpatialFilter> spatialFilters = this.$outer.translateToGeoParquetSpatialFilters((Seq<Expression>)normalizedFiltersWithoutSubquery2);
                        if (!spatialFilters.isEmpty()) {
                            GeoParquetSpatialFilter combinedSpatialFilter = (GeoParquetSpatialFilter)spatialFilters.reduce((Function2)GeoParquetSpatialFilter$AndFilter$.MODULE$);
                            StacScan scan = (StacScan)dataSourceV2ScanRelation.scan();
                            scan.setSpatialPredicates(combinedSpatialFilter);
                            boxedUnit2 = filter.copy(filter.copy$default$1(), filter.copy$default$2());
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        Seq<TemporalFilter> temporalFilters = this.$outer.translateToTemporalFilters((Seq<Expression>)normalizedFiltersWithoutSubquery2);
                        if (!temporalFilters.isEmpty()) {
                            TemporalFilter combinedTemporalFilter = (TemporalFilter)temporalFilters.reduce((Function2)TemporalFilter$AndFilter$.MODULE$);
                            StacScan scan = (StacScan)dataSourceV2ScanRelation.scan();
                            scan.setTemporalPredicates(combinedTemporalFilter);
                            boxedUnit = filter.copy(filter.copy$default$1(), filter.copy$default$2());
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return (B1)filter.copy(filter.copy$default$1(), filter.copy$default$2());
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                DataSourceV2ScanRelation dataSourceV2ScanRelation;
                Filter filter;
                LogicalPlan lr;
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof Filter && (lr = (filter = (Filter)logicalPlan).child()) instanceof DataSourceV2ScanRelation && this.$outer.org$apache$spark$sql$sedona_sql$optimization$SpatialTemporalFilterPushDownForStacScan$$isStacScanRelation(dataSourceV2ScanRelation = (DataSourceV2ScanRelation)lr);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(Expression e) {
                return SubqueryExpression$.MODULE$.hasSubquery(e);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
            }
        });
    }

    public boolean org$apache$spark$sql$sedona_sql$optimization$SpatialTemporalFilterPushDownForStacScan$$isStacScanRelation(DataSourceV2ScanRelation lr) {
        return lr.scan() instanceof StacScan;
    }

    public Seq<TemporalFilter> translateToTemporalFilters(Seq<Expression> predicates) {
        PushableColumnBase pushableColumn = PushableColumn$.MODULE$.apply(true);
        return (Seq)predicates.flatMap((Function1 & Serializable)predicate -> this.translateToTemporalFilter((Expression)predicate, pushableColumn));
    }

    private Option<TemporalFilter> translateToTemporalFilter(Expression predicate, PushableColumnBase pushableColumn) {
        Expression expression = predicate;
        if (expression instanceof And) {
            Option<TemporalFilter> temporalFilterRight;
            And and = (And)expression;
            Expression left = and.left();
            Expression right = and.right();
            Option<TemporalFilter> temporalFilterLeft2 = this.translateToTemporalFilter(left, pushableColumn);
            Tuple2 tuple2 = new Tuple2(temporalFilterLeft2, temporalFilterRight = this.translateToTemporalFilter(right, pushableColumn));
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TemporalFilter l = (TemporalFilter)some.value();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        TemporalFilter r = (TemporalFilter)some2.value();
                        return new Some((Object)new TemporalFilter.AndFilter(l, r));
                    }
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TemporalFilter l = (TemporalFilter)some.value();
                    if (None$.MODULE$.equals(option3)) {
                        return new Some((Object)l);
                    }
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option4 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                    Some some = (Some)option4;
                    TemporalFilter r = (TemporalFilter)some.value();
                    return new Some((Object)r);
                }
            }
            return None$.MODULE$;
        }
        if (expression instanceof Or) {
            Or or = (Or)expression;
            Expression left = or.left();
            Expression right = or.right();
            return this.translateToTemporalFilter(left, pushableColumn).flatMap((Function1 & Serializable)temporalFilterLeft -> this.translateToTemporalFilter(right, pushableColumn).map((Function1 & Serializable)temporalFilterRight -> new TemporalFilter.OrFilter((TemporalFilter)temporalFilterLeft, (TemporalFilter)temporalFilterRight)));
        }
        if (expression instanceof LessThan) {
            Option option;
            LessThan lessThan = (LessThan)expression;
            Expression expression2 = lessThan.left();
            Expression expression3 = lessThan.right();
            if (expression2 != null && !(option = pushableColumn.unapply(expression2)).isEmpty()) {
                String name = (String)option.get();
                if (expression3 instanceof Literal) {
                    Literal literal = (Literal)expression3;
                    Object v = literal.value();
                    DataType dataType = literal.dataType();
                    if (TimestampType$.MODULE$.equals(dataType)) {
                        return new Some((Object)new TemporalFilter.LessThanFilter(this.unquote(name), LocalDateTime.ofInstant(Instant.ofEpochMilli(BoxesRunTime.unboxToLong((Object)v) / 1000L), ZoneOffset.UTC)));
                    }
                }
            }
        }
        if (expression instanceof LessThanOrEqual) {
            Option option;
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)expression;
            Expression expression4 = lessThanOrEqual.left();
            Expression expression5 = lessThanOrEqual.right();
            if (expression4 != null && !(option = pushableColumn.unapply(expression4)).isEmpty()) {
                String name = (String)option.get();
                if (expression5 instanceof Literal) {
                    Literal literal = (Literal)expression5;
                    Object v = literal.value();
                    DataType dataType = literal.dataType();
                    if (TimestampType$.MODULE$.equals(dataType)) {
                        return new Some((Object)new TemporalFilter.LessThanFilter(this.unquote(name), LocalDateTime.ofInstant(Instant.ofEpochMilli(BoxesRunTime.unboxToLong((Object)v) / 1000L), ZoneOffset.UTC)));
                    }
                }
            }
        }
        if (expression instanceof GreaterThan) {
            Option option;
            GreaterThan greaterThan = (GreaterThan)expression;
            Expression expression6 = greaterThan.left();
            Expression expression7 = greaterThan.right();
            if (expression6 != null && !(option = pushableColumn.unapply(expression6)).isEmpty()) {
                String name = (String)option.get();
                if (expression7 instanceof Literal) {
                    Literal literal = (Literal)expression7;
                    Object v = literal.value();
                    DataType dataType = literal.dataType();
                    if (TimestampType$.MODULE$.equals(dataType)) {
                        return new Some((Object)new TemporalFilter.GreaterThanFilter(this.unquote(name), LocalDateTime.ofInstant(Instant.ofEpochMilli(BoxesRunTime.unboxToLong((Object)v) / 1000L), ZoneOffset.UTC)));
                    }
                }
            }
        }
        if (expression instanceof GreaterThanOrEqual) {
            Option option;
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)expression;
            Expression expression8 = greaterThanOrEqual.left();
            Expression expression9 = greaterThanOrEqual.right();
            if (expression8 != null && !(option = pushableColumn.unapply(expression8)).isEmpty()) {
                String name = (String)option.get();
                if (expression9 instanceof Literal) {
                    Literal literal = (Literal)expression9;
                    Object v = literal.value();
                    DataType dataType = literal.dataType();
                    if (TimestampType$.MODULE$.equals(dataType)) {
                        return new Some((Object)new TemporalFilter.GreaterThanFilter(this.unquote(name), LocalDateTime.ofInstant(Instant.ofEpochMilli(BoxesRunTime.unboxToLong((Object)v) / 1000L), ZoneOffset.UTC)));
                    }
                }
            }
        }
        if (expression instanceof EqualTo) {
            Option option;
            EqualTo equalTo = (EqualTo)expression;
            Expression expression10 = equalTo.left();
            Expression expression11 = equalTo.right();
            if (expression10 != null && !(option = pushableColumn.unapply(expression10)).isEmpty()) {
                String name = (String)option.get();
                if (expression11 instanceof Literal) {
                    Literal literal = (Literal)expression11;
                    Object v = literal.value();
                    DataType dataType = literal.dataType();
                    if (TimestampType$.MODULE$.equals(dataType)) {
                        return new Some((Object)new TemporalFilter.EqualFilter(this.unquote(name), LocalDateTime.ofInstant(Instant.ofEpochMilli(BoxesRunTime.unboxToLong((Object)v) / 1000L), ZoneOffset.UTC)));
                    }
                }
            }
        }
        return None$.MODULE$;
    }

    private String unquote(String name) {
        return CatalogV2Implicits$.MODULE$.parseColumnPath(name).mkString(".");
    }

    public SpatialTemporalFilterPushDownForStacScan(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        super(sparkSession);
    }
}

