/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.annotations.GwtCompatible;
import com.google.common.geometry.EncodedInts;
import com.google.common.geometry.InputStreams;
import java.io.IOException;
import java.io.InputStream;

@GwtCompatible
public final class LittleEndianInput {
    private final InputStream input;

    public LittleEndianInput(InputStream input) {
        this.input = input;
    }

    public byte readByte() throws IOException {
        return InputStreams.readByte(this.input);
    }

    public byte[] readBytes(int size) throws IOException {
        byte[] result = new byte[size];
        int numRead = this.input.read(result);
        if (numRead < size) {
            throw new IOException("EOF");
        }
        return result;
    }

    public int readInt() throws IOException {
        return this.readByte() & 0xFF | (this.readByte() & 0xFF) << 8 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 24;
    }

    public long readLong() throws IOException {
        return (long)this.readByte() & 0xFFL | ((long)this.readByte() & 0xFFL) << 8 | ((long)this.readByte() & 0xFFL) << 16 | ((long)this.readByte() & 0xFFL) << 24 | ((long)this.readByte() & 0xFFL) << 32 | ((long)this.readByte() & 0xFFL) << 40 | ((long)this.readByte() & 0xFFL) << 48 | ((long)this.readByte() & 0xFFL) << 56;
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public int readVarint32() throws IOException {
        return (int)this.readVarint64();
    }

    public long readVarint64() throws IOException {
        return EncodedInts.readVarint64(this.input);
    }

    public void close() throws IOException {
        this.input.close();
    }
}

