/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.parser;

import it.geosolutions.jaiext.jiffle.Jiffle;
import it.geosolutions.jaiext.jiffle.parser.BaseWorker;
import it.geosolutions.jaiext.jiffle.parser.JiffleParser;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;

public class ImagesBlockWorker
extends BaseWorker {
    public final Map<String, Jiffle.ImageRole> imageVars = new HashMap<String, Jiffle.ImageRole>();
    private boolean readBlock = false;

    public ImagesBlockWorker(ParseTree tree) {
        super(tree);
        this.walkTree();
    }

    @Override
    public void enterImagesBlock(JiffleParser.ImagesBlockContext ctx) {
        if (this.readBlock) {
            this.messages.error(ctx.start, "Script has more than one image block");
        }
    }

    @Override
    public void exitImagesBlock(JiffleParser.ImagesBlockContext ctx) {
        if (!this.readBlock) {
            block4: for (JiffleParser.ImageVarDeclarationContext imgDecl : ctx.imageVarDeclaration()) {
                String imageName = imgDecl.ID().getText();
                switch (imgDecl.role().getStart().getType()) {
                    case 13: {
                        this.imageVars.put(imageName, Jiffle.ImageRole.SOURCE);
                        continue block4;
                    }
                    case 14: {
                        this.imageVars.put(imageName, Jiffle.ImageRole.DEST);
                        continue block4;
                    }
                }
                Token tok = imgDecl.role().getStart();
                this.messages.error(tok, "Invalid image var type (" + tok.getText() + "). Should be read or write.");
            }
            this.readBlock = true;
        }
    }
}

