/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.dynamicforms.validate;

import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

public class AbstractValidate<T extends AbstractValidate> {
    private final List<String> trigger = Arrays.asList("input", "blur");
    private String message = "required";

    public T withMessage(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.message = message;
        return (T)this;
    }

    public T withI18nMessage(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.message = "i18n." + message;
        return (T)this;
    }

    public List<String> getTrigger() {
        return this.trigger;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractValidate)) {
            return false;
        }
        AbstractValidate other = (AbstractValidate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$trigger = this.getTrigger();
        List<String> other$trigger = other.getTrigger();
        if (this$trigger == null ? other$trigger != null : !((Object)this$trigger).equals(other$trigger)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractValidate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $trigger = this.getTrigger();
        result = result * 59 + ($trigger == null ? 43 : ((Object)$trigger).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractValidate(trigger=" + this.getTrigger() + ", message=" + this.getMessage() + ")";
    }

    public static enum RequiredType {
        NON_EMPTY("non-empty"),
        UNION_NON_EMPTY("union-non-empty"),
        MUTUALLY_EXCLUSIVE("mutually-exclusive");

        private String type;

        private RequiredType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

