/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.dynamicforms;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.seatunnel.app.dynamicforms.validate.AbstractValidate;
import org.apache.seatunnel.shade.com.fasterxml.jackson.annotation.JsonInclude;

public abstract class AbstractFormOption<T extends AbstractFormOption, V extends AbstractValidate> {
    private final String label;
    private final String field;
    private Object defaultValue;
    private String description = "";
    private boolean clearable;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, Object> show;
    private String placeholder = "";
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private V validate;

    public AbstractFormOption(@NonNull String label, @NonNull String field) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        this.label = label;
        this.field = field;
    }

    public T withShow(@NonNull String field, @NonNull List<Object> values) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (this.show == null) {
            this.show = new HashMap<String, Object>();
        }
        this.show.put("field", field);
        this.show.put("value", values);
        return (T)this;
    }

    public T withValidate(@NonNull V validate) {
        if (validate == null) {
            throw new NullPointerException("validate is marked non-null but is null");
        }
        this.validate = validate;
        return (T)this;
    }

    public T withDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return (T)this;
    }

    public T withDescription(@NonNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.description = description;
        return (T)this;
    }

    public T withI18nDescription(@NonNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.description = "i18n." + description;
        return (T)this;
    }

    public T withClearable() {
        this.clearable = true;
        return (T)this;
    }

    public T withPlaceholder(@NonNull String placeholder) {
        if (placeholder == null) {
            throw new NullPointerException("placeholder is marked non-null but is null");
        }
        this.placeholder = placeholder;
        return (T)this;
    }

    public T withI18nPlaceholder(@NonNull String placeholder) {
        if (placeholder == null) {
            throw new NullPointerException("placeholder is marked non-null but is null");
        }
        this.placeholder = "i18n." + placeholder;
        return (T)this;
    }

    public String getLabel() {
        return this.label;
    }

    public String getField() {
        return this.field;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isClearable() {
        return this.clearable;
    }

    public Map<String, Object> getShow() {
        return this.show;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public V getValidate() {
        return this.validate;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setClearable(boolean clearable) {
        this.clearable = clearable;
    }

    public void setShow(Map<String, Object> show) {
        this.show = show;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public void setValidate(V validate) {
        this.validate = validate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractFormOption)) {
            return false;
        }
        AbstractFormOption other = (AbstractFormOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isClearable() != other.isClearable()) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        Object this$defaultValue = this.getDefaultValue();
        Object other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, Object> this$show = this.getShow();
        Map<String, Object> other$show = other.getShow();
        if (this$show == null ? other$show != null : !((Object)this$show).equals(other$show)) {
            return false;
        }
        String this$placeholder = this.getPlaceholder();
        String other$placeholder = other.getPlaceholder();
        if (this$placeholder == null ? other$placeholder != null : !this$placeholder.equals(other$placeholder)) {
            return false;
        }
        V this$validate = this.getValidate();
        V other$validate = other.getValidate();
        return !(this$validate == null ? other$validate != null : !this$validate.equals(other$validate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractFormOption;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isClearable() ? 79 : 97);
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        Object $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, Object> $show = this.getShow();
        result = result * 59 + ($show == null ? 43 : ((Object)$show).hashCode());
        String $placeholder = this.getPlaceholder();
        result = result * 59 + ($placeholder == null ? 43 : $placeholder.hashCode());
        V $validate = this.getValidate();
        result = result * 59 + ($validate == null ? 43 : $validate.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractFormOption(label=" + this.getLabel() + ", field=" + this.getField() + ", defaultValue=" + this.getDefaultValue() + ", description=" + this.getDescription() + ", clearable=" + this.isClearable() + ", show=" + this.getShow() + ", placeholder=" + this.getPlaceholder() + ", validate=" + this.getValidate() + ")";
    }

    public static enum FormType {
        INPUT("input"),
        SELECT("select");

        private String formType;

        private FormType(String formType) {
            this.formType = formType;
        }

        public String getFormType() {
            return this.formType;
        }
    }
}

