/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.type;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.apache.seatunnel.api.table.type.RowKind;

public final class SeaTunnelRow
implements Serializable {
    private static final long serialVersionUID = -1L;
    private String tableId = "";
    private RowKind kind = RowKind.INSERT;
    private final Object[] fields;

    public SeaTunnelRow(int arity) {
        this.fields = new Object[arity];
    }

    public SeaTunnelRow(Object[] fields) {
        this.fields = fields;
    }

    public void setField(int pos, Object value) {
        this.fields[pos] = value;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public void setRowKind(RowKind kind) {
        this.kind = kind;
    }

    public int getArity() {
        return this.fields.length;
    }

    public String getTableId() {
        return this.tableId;
    }

    public RowKind getRowKind() {
        return this.kind;
    }

    public Object[] getFields() {
        return this.fields;
    }

    public Object getField(int pos) {
        return this.fields[pos];
    }

    public SeaTunnelRow copy() {
        Object[] newFields = new Object[this.getArity()];
        System.arraycopy(this.getFields(), 0, newFields, 0, newFields.length);
        SeaTunnelRow newRow = new SeaTunnelRow(newFields);
        newRow.setRowKind(this.getRowKind());
        newRow.setTableId(this.getTableId());
        return newRow;
    }

    public SeaTunnelRow copy(int[] indexMapping) {
        Object[] newFields = new Object[indexMapping.length];
        for (int i = 0; i < indexMapping.length; ++i) {
            newFields[i] = this.fields[indexMapping[i]];
        }
        SeaTunnelRow newRow = new SeaTunnelRow(newFields);
        newRow.setRowKind(this.getRowKind());
        newRow.setTableId(this.getTableId());
        return newRow;
    }

    public boolean isNullAt(int pos) {
        return this.fields[pos] == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SeaTunnelRow)) {
            return false;
        }
        SeaTunnelRow that = (SeaTunnelRow)o;
        return this.tableId == that.tableId && this.kind == that.kind && Arrays.deepEquals(this.fields, that.fields);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.tableId, this.kind});
        result = 31 * result + Arrays.deepHashCode(this.fields);
        return result;
    }

    public String toString() {
        return "SeaTunnelRow{tableId=" + this.tableId + ", kind=" + this.kind.shortString() + ", fields=" + Arrays.toString(this.fields) + '}';
    }
}

