/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.exception.ExecutionNotFoundException;
import com.hazelcast.jet.impl.execution.ExecutionContext;
import com.hazelcast.jet.impl.operation.AbstractJobOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;

public class GetLocalJobMetricsOperation
extends AbstractJobOperation {
    private long executionId;
    private Object response;

    public GetLocalJobMetricsOperation() {
    }

    public GetLocalJobMetricsOperation(long jobId, long executionId) {
        super(jobId);
        this.executionId = executionId;
    }

    @Override
    public void run() {
        JetServiceBackend service = this.getJetServiceBackend();
        ExecutionContext executionContext = service.getJobExecutionService().getExecutionContext(this.executionId);
        if (executionContext == null) {
            throw new ExecutionNotFoundException(this.executionId);
        }
        this.response = executionContext.getJobMetrics();
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public int getClassId() {
        return 35;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
    }
}

