/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.DoubleGauge;
import com.hazelcast.internal.metrics.DoubleProbeFunction;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.LongProbeFunction;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.ProbeFunction;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.metrics.StaticMetricsProvider;
import com.hazelcast.internal.metrics.collectors.MetricsCollector;
import com.hazelcast.internal.metrics.impl.AbstractGauge;
import com.hazelcast.internal.metrics.impl.DefaultMetricDescriptorSupplier;
import com.hazelcast.internal.metrics.impl.DoubleGaugeImpl;
import com.hazelcast.internal.metrics.impl.FieldProbe;
import com.hazelcast.internal.metrics.impl.LongGaugeImpl;
import com.hazelcast.internal.metrics.impl.MethodProbe;
import com.hazelcast.internal.metrics.impl.MetricDescriptorImpl;
import com.hazelcast.internal.metrics.impl.MetricValueCatcher;
import com.hazelcast.internal.metrics.impl.MetricsCollectionCycle;
import com.hazelcast.internal.metrics.impl.MetricsUtil;
import com.hazelcast.internal.metrics.impl.ProbeInstance;
import com.hazelcast.internal.metrics.impl.SourceMetadata;
import com.hazelcast.internal.util.ConcurrentReferenceHashMap;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.concurrent.ThreadFactoryImpl;
import com.hazelcast.internal.util.executor.LoggingScheduledExecutor;
import com.hazelcast.logging.ILogger;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class MetricsRegistryImpl
implements MetricsRegistry {
    final ILogger logger;
    private final ProbeLevel minimumLevel;
    private final ScheduledExecutorService scheduler;
    private final ConcurrentMap<MetricDescriptorImpl.LookupView, ProbeInstance> probeInstances = new ConcurrentHashMap<MetricDescriptorImpl.LookupView, ProbeInstance>();
    private final ConcurrentMap<Class<?>, SourceMetadata> metadataMap = new ConcurrentReferenceHashMap();
    private final ConcurrentMap<MetricDescriptorImpl.LookupView, AbstractGauge> gauges = new ConcurrentReferenceHashMap<MetricDescriptorImpl.LookupView, AbstractGauge>(ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);
    private final ConcurrentMap<DynamicMetricsProvider, Boolean> metricSourceMap = new ConcurrentReferenceHashMap<DynamicMetricsProvider, Boolean>(ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.STRONG, EnumSet.of(ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS));
    private final DefaultMetricDescriptorSupplier staticDescriptorSupplier = new DefaultMetricDescriptorSupplier();

    public MetricsRegistryImpl(ILogger logger, ProbeLevel minimumLevel) {
        this("default", logger, minimumLevel);
    }

    public MetricsRegistryImpl(String name, ILogger logger, ProbeLevel minimumLevel) {
        this.logger = Preconditions.checkNotNull(logger, "logger can't be null");
        this.minimumLevel = Preconditions.checkNotNull(minimumLevel, "minimumLevel can't be null");
        this.scheduler = new LoggingScheduledExecutor(logger, 2, new ThreadFactoryImpl(ThreadUtil.createThreadPoolName(name, "MetricsRegistry")));
        if (logger.isFinestEnabled()) {
            logger.finest("MetricsRegistry minimumLevel:" + (Object)((Object)minimumLevel));
        }
    }

    @Override
    public ProbeLevel minimumLevel() {
        return this.minimumLevel;
    }

    @Override
    public Set<String> getNames() {
        return Collections.unmodifiableSet(this.probeInstances.values().stream().map(probeInstance -> probeInstance.descriptor.metricString()).collect(Collectors.toSet()));
    }

    SourceMetadata loadSourceMetadata(Class<?> clazz) {
        SourceMetadata metadata = (SourceMetadata)this.metadataMap.get(clazz);
        if (metadata == null) {
            metadata = new SourceMetadata(clazz);
            SourceMetadata found = this.metadataMap.putIfAbsent(clazz, metadata);
            metadata = found == null ? metadata : found;
        }
        return metadata;
    }

    @Override
    public <S> void registerStaticMetrics(S source, String namePrefix) {
        Preconditions.checkNotNull(source, "source can't be null");
        Preconditions.checkNotNull(namePrefix, "namePrefix can't be null");
        this.registerStaticMetrics(this.newMetricDescriptor().withPrefix(namePrefix), source);
    }

    @Override
    public <S> void registerStaticMetrics(MetricDescriptor descriptor, S source) {
        Preconditions.checkNotNull(descriptor, "descriptor can't be null");
        Preconditions.checkNotNull(source, "source can't be null");
        SourceMetadata metadata = this.loadSourceMetadata(source.getClass());
        for (FieldProbe field : metadata.fields()) {
            field.register(this, descriptor, source);
        }
        for (MethodProbe method : metadata.methods()) {
            method.register(this, descriptor, source);
        }
    }

    @Override
    public void registerDynamicMetricsProvider(DynamicMetricsProvider metricsProvider) {
        this.metricSourceMap.put(metricsProvider, Boolean.TRUE);
    }

    @Override
    public void deregisterDynamicMetricsProvider(DynamicMetricsProvider metricsProvider) {
        this.metricSourceMap.remove(metricsProvider);
    }

    @Override
    public <S> void registerStaticProbe(S source, MetricDescriptor descriptor, String name, ProbeLevel level, ProbeUnit unit, ProbeFunction function) {
        this.registerStaticProbeWithUnit(source, descriptor, name, level, unit, function);
    }

    @Override
    public <S> void registerStaticProbe(S source, String name, ProbeLevel level, LongProbeFunction<S> function) {
        this.registerStaticProbeWithoutUnit(source, name, level, function);
    }

    @Override
    public <S> void registerStaticProbe(S source, String name, ProbeLevel level, ProbeUnit unit, LongProbeFunction<S> function) {
        this.registerStaticProbeWithUnit(source, this.staticDescriptorSupplier.get(), name, level, unit, function);
    }

    @Override
    public <S> void registerStaticProbe(S source, MetricDescriptor descriptor, String name, ProbeLevel level, ProbeUnit unit, LongProbeFunction<S> function) {
        this.registerStaticProbeWithUnit(source, descriptor, name, level, unit, function);
    }

    @Override
    public <S> void registerStaticProbe(S source, String name, ProbeLevel level, DoubleProbeFunction<S> function) {
        this.registerStaticProbeWithoutUnit(source, name, level, function);
    }

    @Override
    public <S> void registerStaticProbe(S source, String name, ProbeLevel level, ProbeUnit unit, DoubleProbeFunction<S> function) {
        this.registerStaticProbeWithUnit(source, this.staticDescriptorSupplier.get(), name, level, unit, function);
    }

    @Override
    public <S> void registerStaticProbe(S source, MetricDescriptor descriptor, String name, ProbeLevel level, ProbeUnit unit, DoubleProbeFunction<S> function) {
        this.registerStaticProbeWithUnit(source, descriptor, name, level, unit, function);
    }

    private <S> void registerStaticProbeWithoutUnit(S source, String name, ProbeLevel level, ProbeFunction function) {
        Preconditions.checkNotNull(source, "source can't be null");
        Preconditions.checkNotNull(name, "name can't be null");
        Preconditions.checkNotNull(function, "function can't be null");
        Preconditions.checkNotNull(level, "level can't be null");
        this.registerInternal(source, this.createDescriptor(name), level, function);
    }

    private <S> void registerStaticProbeWithUnit(S source, MetricDescriptor descriptor, String name, ProbeLevel level, ProbeUnit unit, ProbeFunction function) {
        this.registerInternal(source, descriptor.copy().withUnit(unit).withMetric(name), level, function);
    }

    ProbeInstance getProbeInstance(String name) {
        Preconditions.checkNotNull(name, "name can't be null");
        return (ProbeInstance)this.probeInstances.get(this.createDescriptor(name).lookupView());
    }

    <S> void registerInternal(S source, MetricDescriptor descriptor, ProbeLevel probeLevel, ProbeFunction function) {
        AbstractGauge gauge;
        if (!probeLevel.isEnabled(this.minimumLevel)) {
            return;
        }
        descriptor.withExcludedTargets(MetricsUtil.extractExcludedTargets(function));
        MetricDescriptorImpl.LookupView descriptorLookupView = ((MetricDescriptorImpl)descriptor).lookupView();
        ProbeInstance probeInstance = this.probeInstances.computeIfAbsent(descriptorLookupView, k -> new ProbeInstance<Object>(descriptor, source, function));
        if (probeInstance.source == source && probeInstance.function == function) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Registered probeInstance " + descriptor.metricString());
            }
        } else {
            this.logOverwrite(probeInstance);
            probeInstance.source = source;
            probeInstance.function = function;
        }
        if ((gauge = (AbstractGauge)this.gauges.get(descriptorLookupView)) != null) {
            gauge.onProbeInstanceSet(probeInstance);
        }
    }

    private void logOverwrite(ProbeInstance probeInstance) {
        if (probeInstance.function != null || probeInstance.source != null) {
            this.logger.warning(String.format("Overwriting existing probe '%s'", probeInstance.descriptor));
        }
    }

    @Override
    public LongGaugeImpl newLongGauge(String name) {
        Preconditions.checkNotNull(name, "name can't be null");
        LongGaugeImpl gauge = new LongGaugeImpl(this, name);
        this.gauges.put(this.createDescriptor(name).lookupView(), gauge);
        return gauge;
    }

    @Override
    public DoubleGauge newDoubleGauge(String name) {
        Preconditions.checkNotNull(name, "name can't be null");
        DoubleGaugeImpl gauge = new DoubleGaugeImpl(this, name);
        this.gauges.put(this.createDescriptor(name).lookupView(), gauge);
        return gauge;
    }

    private MetricDescriptorImpl createDescriptor(String name) {
        MetricDescriptorImpl descriptor = new MetricDescriptorImpl(this.staticDescriptorSupplier);
        int dotIdx = name.lastIndexOf(46);
        if (dotIdx < 0) {
            descriptor.withMetric(name);
            return descriptor;
        }
        descriptor.withMetric(name.substring(dotIdx + 1));
        int bracketOpenIdx = name.indexOf(91);
        if (bracketOpenIdx > 0) {
            int bracketCloseIdx = name.indexOf(93);
            String prefix = name.substring(0, bracketOpenIdx);
            String discriminator = name.substring(bracketOpenIdx + 1, bracketCloseIdx);
            descriptor.withPrefix(prefix).withDiscriminator("ignored", discriminator);
        } else {
            descriptor.withPrefix(name.substring(0, dotIdx));
        }
        return descriptor;
    }

    @Override
    public void collect(MetricsCollector collector) {
        Preconditions.checkNotNull(collector, "collector can't be null");
        MetricsCollectionCycle collectionCycle = new MetricsCollectionCycle(this::loadSourceMetadata, this::lookupMetricValueCatcher, collector, this.minimumLevel);
        collectionCycle.collectStaticMetrics(this.probeInstances);
        collectionCycle.collectDynamicMetrics(this.metricSourceMap.keySet());
        collectionCycle.notifyAllGauges(this.gauges.values());
        collectionCycle.cleanUp();
    }

    private MetricValueCatcher lookupMetricValueCatcher(MetricDescriptor descriptor) {
        AbstractGauge gauge = (AbstractGauge)this.gauges.get(((MetricDescriptorImpl)descriptor).lookupView());
        return gauge != null ? gauge.getCatcherOrNull() : null;
    }

    @Override
    public void provideMetrics(Object ... providers) {
        for (Object provider : providers) {
            if (!(provider instanceof StaticMetricsProvider)) continue;
            ((StaticMetricsProvider)provider).provideStaticMetrics(this);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable publisher, long period, TimeUnit timeUnit, ProbeLevel probeLevel) {
        if (!probeLevel.isEnabled(this.minimumLevel)) {
            return null;
        }
        return this.scheduler.scheduleAtFixedRate(publisher, 0L, period, timeUnit);
    }

    public void shutdown() {
        this.scheduler.shutdownNow();
    }

    @Override
    public MetricDescriptorImpl newMetricDescriptor() {
        return this.staticDescriptorSupplier.get();
    }
}

