/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class MultiMapUnlockCodec {
    public static final int REQUEST_MESSAGE_TYPE = 135936;
    public static final int RESPONSE_MESSAGE_TYPE = 135937;
    private static final int REQUEST_THREAD_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_REFERENCE_ID_FIELD_OFFSET = 24;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 32;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private MultiMapUnlockCodec() {
    }

    public static ClientMessage encodeRequest(String name, Data key, long threadId, long referenceId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("MultiMap.Unlock");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[32], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 135936);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, threadId);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 24, referenceId);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        DataCodec.encode(clientMessage, key);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.threadId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        request.referenceId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 24);
        request.name = StringCodec.decode(iterator);
        request.key = DataCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 135937);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public Data key;
        public long threadId;
        public long referenceId;
    }
}

