/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.datasource;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.RequiredOption;
import org.apache.seatunnel.app.domain.request.connector.BusinessMode;
import org.apache.seatunnel.app.domain.request.job.DataSourceOption;
import org.apache.seatunnel.app.domain.request.job.SelectTableFields;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableDetailRes;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.thirdparty.datasource.DataSourceConfigSwitcher;
import org.apache.seatunnel.app.thirdparty.datasource.DatasourceConfigSwitcherProvider;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class DataSourceConfigSwitcherUtils {
    public static FormStructure filterOptionRule(String datasourceName, String connectorName, OptionRule dataSourceOptionRule, OptionRule virtualTableOptionRule, PluginType pluginType, BusinessMode businessMode, OptionRule connectorOptionRule) {
        DataSourceConfigSwitcher dataSourceConfigSwitcher = DataSourceConfigSwitcherUtils.getDataSourceConfigSwitcher(datasourceName.toUpperCase());
        return dataSourceConfigSwitcher.filterOptionRule(connectorName, dataSourceOptionRule, virtualTableOptionRule, businessMode, pluginType, connectorOptionRule, new ArrayList<RequiredOption>(), new ArrayList(), new ArrayList<String>());
    }

    public static Config mergeDatasourceConfig(String datasourceName, Config dataSourceInstanceConfig, VirtualTableDetailRes virtualTableDetail, DataSourceOption dataSourceOption, SelectTableFields selectTableFields, BusinessMode businessMode, PluginType pluginType, Config connectorConfig) {
        DataSourceConfigSwitcher dataSourceConfigSwitcher = DataSourceConfigSwitcherUtils.getDataSourceConfigSwitcher(datasourceName.toUpperCase());
        return dataSourceConfigSwitcher.mergeDatasourceConfig(dataSourceInstanceConfig, virtualTableDetail, dataSourceOption, selectTableFields, businessMode, pluginType, connectorConfig);
    }

    private static DataSourceConfigSwitcher getDataSourceConfigSwitcher(String datasourceName) {
        Preconditions.checkNotNull((Object)datasourceName, (Object)"datasourceName cannot be null");
        DataSourceConfigSwitcher configSwitcher = DatasourceConfigSwitcherProvider.INSTANCE.getConfigSwitcher(datasourceName.toUpperCase());
        if (configSwitcher == null) {
            throw new SeaTunnelException("data source : " + datasourceName + " is no implementation class for DataSourceConfigSwitcher");
        }
        return configSwitcher;
    }
}

