/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.app.config.ConnectorDataSourceMapperConfig;
import org.apache.seatunnel.app.dal.dao.IDatasourceDao;
import org.apache.seatunnel.app.dal.dao.IVirtualTableDao;
import org.apache.seatunnel.app.dal.entity.Datasource;
import org.apache.seatunnel.app.dal.entity.VirtualTable;
import org.apache.seatunnel.app.domain.request.datasource.VirtualTableFieldReq;
import org.apache.seatunnel.app.domain.request.datasource.VirtualTableReq;
import org.apache.seatunnel.app.domain.response.PageInfo;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableDetailRes;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableFieldRes;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableRes;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.service.IJobDefinitionService;
import org.apache.seatunnel.app.service.IVirtualTableService;
import org.apache.seatunnel.app.service.impl.SeatunnelBaseServiceImpl;
import org.apache.seatunnel.app.thirdparty.datasource.DataSourceClientFactory;
import org.apache.seatunnel.app.thirdparty.framework.SeaTunnelOptionRuleWrapper;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.server.common.CodeGenerateUtils;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VirtualTableServiceImpl
extends SeatunnelBaseServiceImpl
implements IVirtualTableService {
    @Resource(name="virtualTableDaoImpl")
    IVirtualTableDao virtualTableDao;
    @Autowired
    private IJobDefinitionService jobDefinitionService;
    @Resource(name="datasourceDaoImpl")
    IDatasourceDao datasourceDao;
    @Autowired
    private ConnectorDataSourceMapperConfig dataSourceMapperConfig;

    @Override
    public String createVirtualTable(Integer userId, VirtualTableReq req) throws CodeGenerateUtils.CodeGenerateException {
        this.funcPermissionCheck("datasource:virtual-table-create", userId);
        long uuid = CodeGenerateUtils.getInstance().genCode();
        Long datasourceId = Long.valueOf(req.getDatasourceId());
        boolean isUnique = this.virtualTableDao.checkVirtualTableNameUnique(req.getTableName(), req.getDatabaseName(), 0L);
        if (!isUnique) {
            throw new SeatunnelException(SeatunnelErrorEnum.VIRTUAL_TABLE_ALREADY_EXISTS, new Object[]{req.getTableName()});
        }
        VirtualTable virtualTable = VirtualTable.builder().id(uuid).datasourceId(datasourceId).virtualDatabaseName(req.getDatabaseName()).virtualTableName(req.getTableName()).description(req.getDescription()).createTime(new Date()).updateTime(new Date()).createUserId(userId).updateUserId(userId).build();
        if (CollectionUtils.isEmpty(req.getTableFields())) {
            throw new SeatunnelException(SeatunnelErrorEnum.VIRTUAL_TABLE_FIELD_EMPTY);
        }
        String fieldJson = this.convertTableFields(req.getTableFields());
        virtualTable.setTableFields(fieldJson);
        virtualTable.setVirtualTableConfig(JsonUtils.toJsonString(req.getDatabaseProperties()));
        boolean success = this.virtualTableDao.insertVirtualTable(virtualTable);
        if (!success) {
            throw new SeatunnelException(SeatunnelErrorEnum.VIRTUAL_TABLE_CREATE_FAILED);
        }
        return String.valueOf(uuid);
    }

    private String convertTableFields(List<VirtualTableFieldReq> tableFields) {
        ArrayList<VirtualTableFieldRes> fieldList = new ArrayList<VirtualTableFieldRes>();
        if (CollectionUtils.isNotEmpty(tableFields)) {
            for (VirtualTableFieldReq field : tableFields) {
                VirtualTableFieldRes fieldRes = VirtualTableFieldRes.builder().fieldName(field.getFieldName()).fieldType(field.getFieldType()).fieldExtra(field.getFieldExtra()).defaultValue(field.getDefaultValue()).primaryKey(field.getPrimaryKey()).nullable(field.getNullable()).fieldComment(field.getFieldComment()).build();
                fieldList.add(fieldRes);
            }
        }
        return JsonUtils.toJsonString(fieldList);
    }

    @Override
    public Boolean updateVirtualTable(@NotNull Integer userId, @NotNull String tableId, VirtualTableReq req) {
        boolean isUnique;
        this.funcPermissionCheck("datasource:virtual-table-update", userId);
        VirtualTable originalTable = this.virtualTableDao.selectVirtualTableById(Long.valueOf(tableId));
        if (null == originalTable) {
            throw new SeatunnelException(SeatunnelErrorEnum.VIRTUAL_TABLE_NOT_EXISTS);
        }
        if (StringUtils.isNotBlank((CharSequence)req.getTableName()) && !(isUnique = this.virtualTableDao.checkVirtualTableNameUnique(req.getTableName(), req.getDatabaseName(), Long.valueOf(tableId)))) {
            throw new SeatunnelException(SeatunnelErrorEnum.VIRTUAL_TABLE_ALREADY_EXISTS, new Object[]{req.getTableName()});
        }
        VirtualTable virtualTable = VirtualTable.builder().id(Long.valueOf(tableId)).datasourceId(originalTable.getDatasourceId()).virtualDatabaseName(req.getDatabaseName()).virtualTableName(req.getTableName()).description(req.getDescription()).updateTime(new Date()).updateUserId(userId).build();
        if (CollectionUtils.isNotEmpty(req.getTableFields())) {
            String fieldJson = this.convertTableFields(req.getTableFields());
            virtualTable.setTableFields(fieldJson);
        }
        virtualTable.setVirtualTableConfig(JsonUtils.toJsonString(req.getDatabaseProperties()));
        return this.virtualTableDao.updateVirtualTable(virtualTable);
    }

    @Override
    public Boolean deleteVirtualTable(@NotNull Integer userId, @NotNull String tableId) {
        this.funcPermissionCheck("datasource:virtual-table-delete", userId);
        VirtualTable virtualTable = this.virtualTableDao.selectVirtualTableById(Long.valueOf(tableId));
        if (virtualTable == null) {
            throw new SeatunnelException(SeatunnelErrorEnum.VIRTUAL_TABLE_NOT_EXISTS);
        }
        if (this.jobDefinitionService.getUsedByDataSourceIdAndVirtualTable(virtualTable.getDatasourceId(), virtualTable.getVirtualTableName())) {
            throw new SeatunnelException(SeatunnelErrorEnum.VIRTUAL_TABLE_CAN_NOT_DELETE);
        }
        return this.virtualTableDao.deleteVirtualTable(Long.valueOf(tableId));
    }

    @Override
    public Boolean checkVirtualTableValid(VirtualTableReq req) {
        return true;
    }

    @Override
    public String queryTableDynamicTable(String pluginName) {
        OptionRule rule = DataSourceClientFactory.getDataSourceClient().queryMetadataFieldByName(pluginName);
        if (null == rule) {
            throw new SeatunnelException(SeatunnelErrorEnum.DATASOURCE_NOT_EXISTS);
        }
        String connectorForDatasourceName = this.dataSourceMapperConfig.findConnectorForDatasourceName(pluginName).orElseThrow(() -> new SeatunnelException(SeatunnelErrorEnum.CAN_NOT_FOUND_CONNECTOR_FOR_DATASOURCE, new Object[]{pluginName}));
        FormStructure form = SeaTunnelOptionRuleWrapper.wrapper(rule, connectorForDatasourceName);
        return JsonUtils.toJsonString((Object)form);
    }

    @Override
    public VirtualTableDetailRes queryVirtualTableByTableName(String tableName) {
        VirtualTable virtualTable = this.virtualTableDao.selectVirtualTableByTableName(tableName);
        return this.buildVirtualTableDetailRes(virtualTable);
    }

    @Override
    public boolean containsVirtualTableByTableName(String tableName) {
        return null != this.virtualTableDao.selectVirtualTableByTableName(tableName);
    }

    private VirtualTableDetailRes buildVirtualTableDetailRes(VirtualTable virtualTable) {
        if (null == virtualTable) {
            throw new SeatunnelException(SeatunnelErrorEnum.VIRTUAL_TABLE_NOT_EXISTS);
        }
        Datasource datasource = this.datasourceDao.selectDatasourceById(virtualTable.getDatasourceId());
        if (null == datasource) {
            throw new SeatunnelException(SeatunnelErrorEnum.DATASOURCE_NOT_EXISTS);
        }
        VirtualTableDetailRes res = new VirtualTableDetailRes();
        res.setTableId(String.valueOf(virtualTable.getId()));
        res.setTableName(virtualTable.getVirtualTableName());
        res.setDatabaseName(virtualTable.getVirtualDatabaseName());
        res.setDescription(virtualTable.getDescription());
        res.setDatasourceId(String.valueOf(virtualTable.getDatasourceId()));
        res.setPluginName(datasource.getPluginName());
        res.setCreateTime(virtualTable.getCreateTime());
        res.setUpdateTime(virtualTable.getUpdateTime());
        res.setDatasourceName(datasource.getDatasourceName());
        res.setDatasourceProperties(JsonUtils.toMap((String)virtualTable.getVirtualTableConfig()));
        List fields = JsonUtils.toList((String)virtualTable.getTableFields(), VirtualTableFieldRes.class);
        res.setFields(fields);
        return res;
    }

    @Override
    public VirtualTableDetailRes queryVirtualTable(@NotNull String tableId) {
        this.funcPermissionCheck("datasource:virtual-table-detail", 0);
        VirtualTable virtualTable = this.virtualTableDao.selectVirtualTableById(Long.valueOf(tableId));
        return this.buildVirtualTableDetailRes(virtualTable);
    }

    @Override
    public PageInfo<VirtualTableRes> getVirtualTableList(String pluginName, String datasourceName, Integer pageNo, Integer pageSize) {
        this.funcPermissionCheck("datasource:virtual-table-view", 0);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<VirtualTable> iPage = this.virtualTableDao.selectVirtualTablePage((Page<VirtualTable>)page, pluginName, datasourceName);
        PageInfo<VirtualTableRes> pageInfo = new PageInfo<VirtualTableRes>();
        pageInfo.setPageNo((int)iPage.getPages());
        pageInfo.setPageSize((int)iPage.getSize());
        pageInfo.setTotalCount((int)iPage.getTotal());
        ArrayList resList = new ArrayList();
        ArrayList<Long> datasourceIds = new ArrayList<Long>();
        if (CollectionUtils.isEmpty((Collection)iPage.getRecords())) {
            pageInfo.setData(resList);
            return pageInfo;
        }
        iPage.getRecords().forEach(virtualTable -> datasourceIds.add(virtualTable.getDatasourceId()));
        List<Datasource> datasourceList = this.datasourceDao.selectDatasourceByIds(datasourceIds);
        Map<Long, String> datasourceMap = datasourceList.stream().collect(Collectors.toMap(Datasource::getId, Datasource::getDatasourceName));
        Map<Long, String> datasourcePluginNameMap = datasourceList.stream().collect(Collectors.toMap(Datasource::getId, Datasource::getPluginName));
        iPage.getRecords().forEach(virtualTable -> {
            VirtualTableRes res = new VirtualTableRes();
            res.setTableId(String.valueOf(virtualTable.getId()));
            res.setTableName(virtualTable.getVirtualTableName());
            res.setDatabaseName(virtualTable.getVirtualDatabaseName());
            res.setDescription(virtualTable.getDescription());
            res.setDatasourceId(String.valueOf(virtualTable.getDatasourceId()));
            res.setCreateUserId(virtualTable.getCreateUserId());
            res.setUpdateUserId(virtualTable.getUpdateUserId());
            res.setCreateTime(virtualTable.getCreateTime());
            res.setUpdateTime(virtualTable.getUpdateTime());
            res.setDatasourceName((String)datasourceMap.get(virtualTable.getDatasourceId()));
            res.setPluginName((String)datasourcePluginNameMap.get(virtualTable.getDatasourceId()));
            resList.add(res);
        });
        pageInfo.setData(resList);
        return pageInfo;
    }

    @Override
    public List<String> getVirtualTableNames(String databaseName, String datasourceId) {
        Long datasourceIdLong = Long.valueOf(datasourceId);
        return this.virtualTableDao.getVirtualTableNames(databaseName, datasourceIdLong);
    }

    @Override
    public List<String> getVirtualDatabaseNames(String datasourceId) {
        Long datasourceIdLong = Long.valueOf(datasourceId);
        return this.virtualTableDao.getVirtualDatabaseNames(datasourceIdLong);
    }

    private VirtualTableFieldRes convertVirtualTableFieldReq(VirtualTableFieldReq req) {
        return VirtualTableFieldRes.builder().fieldName(req.getFieldName()).fieldType(req.getFieldType()).nullable(req.getNullable()).defaultValue(req.getDefaultValue()).fieldComment(req.getFieldComment()).primaryKey(req.getPrimaryKey()).build();
    }
}

