/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.domain.response;

import io.swagger.annotations.ApiModel;
import java.util.Collections;
import java.util.List;

@ApiModel(value="pageInfo", description="page info")
public class PageInfo<T> {
    private List<T> data = Collections.emptyList();
    private Integer totalCount = 0;
    private Integer totalPage = 0;
    private Integer pageNo = 1;
    private Integer pageSize = 20;
    private Integer currentPage = 0;

    public PageInfo() {
    }

    public PageInfo(Integer currentPage, Integer pageSize) {
        if (currentPage == null) {
            currentPage = 1;
        }
        this.pageNo = (currentPage - 1) * pageSize;
        this.pageSize = pageSize;
        this.currentPage = currentPage;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
        if (this.pageSize == null || this.pageSize == 0) {
            this.pageSize = 20;
        }
        if (this.totalCount % this.pageSize == 0) {
            this.totalPage = this.totalCount / this.pageSize == 0 ? 1 : this.totalCount / this.pageSize;
            return;
        }
        this.totalPage = this.totalCount / this.pageSize + 1;
    }

    public Integer getTotalPage() {
        return this.totalPage;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}

