/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.dal.dao.impl;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.seatunnel.app.common.UserStatusEnum;
import org.apache.seatunnel.app.common.UserTokenStatusEnum;
import org.apache.seatunnel.app.dal.dao.IUserDao;
import org.apache.seatunnel.app.dal.entity.User;
import org.apache.seatunnel.app.dal.entity.UserLoginLog;
import org.apache.seatunnel.app.dal.mapper.UserLoginLogMapper;
import org.apache.seatunnel.app.dal.mapper.UserMapper;
import org.apache.seatunnel.app.domain.dto.user.ListUserDto;
import org.apache.seatunnel.app.domain.dto.user.UpdateUserDto;
import org.apache.seatunnel.app.domain.dto.user.UserLoginLogDto;
import org.apache.seatunnel.server.common.PageData;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.springframework.stereotype.Repository;

@Repository
public class UserDaoImpl
implements IUserDao {
    @Resource
    private UserMapper userMapper;
    @Resource
    private UserLoginLogMapper userLoginLogMapper;

    @Override
    public int add(UpdateUserDto dto) {
        User user = new User();
        user.setUsername(dto.getUsername());
        user.setPassword(dto.getPassword());
        user.setType((byte)dto.getType());
        user.setStatus((byte)dto.getStatus());
        this.userMapper.insert(user);
        return user.getId();
    }

    @Override
    public void checkUserExists(String username) {
        User user = this.userMapper.selectByName(username);
        Preconditions.checkState((boolean)Objects.isNull(user), (Object)String.format(SeatunnelErrorEnum.USER_ALREADY_EXISTS.getTemplate(), username));
    }

    @Override
    public void update(UpdateUserDto dto) {
        User user = new User();
        user.setUsername(dto.getUsername());
        user.setPassword(dto.getPassword());
        user.setType((byte)dto.getType());
        user.setStatus((byte)dto.getStatus());
        user.setId(dto.getId());
        int i = this.userMapper.updateByPrimaryKey(user);
        Preconditions.checkState((i == 1 ? 1 : 0) != 0, (Object)SeatunnelErrorEnum.NO_SUCH_USER.getTemplate());
    }

    @Override
    public void delete(int id) {
        this.userMapper.deleteByPrimaryKey(id);
    }

    @Override
    public void enable(int id) {
        this.userMapper.updateStatus(id, (byte)UserStatusEnum.ENABLE.getCode());
    }

    @Override
    public void disable(int id) {
        this.userMapper.updateStatus(id, (byte)UserStatusEnum.DISABLE.getCode());
    }

    @Override
    public PageData<User> list(ListUserDto dto, int pageNo, int pageSize) {
        User user = new User();
        user.setUsername(dto.getName());
        int count = this.userMapper.countBySelective(user);
        List<User> userList = this.userMapper.selectBySelectiveAndPage(user, pageNo * pageSize, pageSize);
        return new PageData(count, userList);
    }

    @Override
    public User getById(int operatorId) {
        return this.userMapper.selectByPrimaryKey(operatorId);
    }

    @Override
    public User getByName(String user) {
        return this.userMapper.selectByName(user);
    }

    @Override
    public User checkPassword(String username, String password) {
        return this.userMapper.selectByNameAndPasswd(username, password);
    }

    @Override
    public long insertLoginLog(UserLoginLogDto dto) {
        UserLoginLog log = new UserLoginLog();
        log.setToken(dto.getToken());
        log.setTokenStatus(dto.getTokenStatus());
        log.setUserId(dto.getUserId());
        this.userLoginLogMapper.insert(log);
        return log.getId();
    }

    @Override
    public void disableToken(int userId) {
        this.userLoginLogMapper.updateStatus(userId, UserTokenStatusEnum.DISABLE.enable());
    }

    @Override
    public UserLoginLog getLastLoginLog(Integer userId) {
        return this.userLoginLogMapper.checkLastTokenEnable(userId);
    }

    @Override
    public List<User> queryEnabledUsers() {
        return this.userMapper.queryEnabledUsers();
    }
}

