/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.dal.dao.impl;

import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.seatunnel.app.dal.dao.IScriptJobApplyDao;
import org.apache.seatunnel.app.dal.entity.JobDefine;
import org.apache.seatunnel.app.dal.entity.ScriptJobApply;
import org.apache.seatunnel.app.dal.mapper.ScriptJobApplyMapper;
import org.apache.seatunnel.app.domain.dto.job.ScriptJobApplyDto;
import org.springframework.stereotype.Repository;

@Repository
public class ScriptJobApplyDaoImpl
implements IScriptJobApplyDao {
    @Resource
    private ScriptJobApplyMapper scriptJobApplyMapper;

    @Override
    public void insertOrUpdate(ScriptJobApplyDto dto) {
        ScriptJobApply apply = this.scriptJobApplyMapper.selectByScriptId(dto.getScriptId());
        if (Objects.isNull(apply)) {
            apply = new ScriptJobApply();
            apply.setScriptId(dto.getScriptId());
            apply.setJobId(dto.getJobId());
            apply.setOperatorId(dto.getUserId());
            apply.setSchedulerConfigId(dto.getSchedulerConfigId());
            this.scriptJobApplyMapper.insert(apply);
        } else {
            apply.setJobId(dto.getJobId());
            apply.setOperatorId(dto.getUserId());
            apply.setSchedulerConfigId(dto.getSchedulerConfigId());
            this.scriptJobApplyMapper.update(apply);
        }
    }

    @Override
    public ScriptJobApply getByScriptId(Integer id) {
        return this.scriptJobApplyMapper.selectByScriptId(id);
    }

    @Override
    public List<JobDefine> selectJobDefineByJobIds(List<Long> jobIds) {
        return this.scriptJobApplyMapper.selectJobDefineByJobIds(jobIds);
    }

    @Override
    public ScriptJobApply getByJobId(long jobId) {
        return this.scriptJobApplyMapper.selectByJobId(jobId);
    }
}

