/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.checkpoint.storage.hdfs.common;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.seatunnel.engine.checkpoint.storage.hdfs.common.AbstractConfiguration;

public class S3Configuration
extends AbstractConfiguration {
    public static final String S3_BUCKET_KEY = "s3.bucket";
    private static final String HDFS_S3N_IMPL = "org.apache.hadoop.fs.s3native.NativeS3FileSystem";
    private static final String HDFS_S3A_IMPL = "org.apache.hadoop.fs.s3a.S3AFileSystem";
    private static final String S3A_PROTOCOL = "s3a";
    private static final String DEFAULT_PROTOCOL = "s3n";
    private static final String S3_FORMAT_KEY = "fs.%s.%s";
    private static final String SPLIT_CHAR = ".";
    private static final String FS_KEY = "fs.";

    @Override
    public Configuration buildConfiguration(Map<String, String> config) {
        this.checkConfiguration(config, S3_BUCKET_KEY);
        String protocol = DEFAULT_PROTOCOL;
        if (config.get(S3_BUCKET_KEY).startsWith(S3A_PROTOCOL)) {
            protocol = S3A_PROTOCOL;
        }
        String fsImpl = protocol.equals(S3A_PROTOCOL) ? HDFS_S3A_IMPL : HDFS_S3N_IMPL;
        Configuration hadoopConf = new Configuration();
        hadoopConf.set("fs.defaultFS", config.get(S3_BUCKET_KEY));
        hadoopConf.set(this.formatKey(protocol, "impl"), fsImpl);
        hadoopConf.setBoolean(String.format("%s.disable.cache", this.formatKey(protocol, "impl")), Boolean.parseBoolean(config.getOrDefault("disable.cache", "TRUE")));
        this.setExtraConfiguration(hadoopConf, config, FS_KEY + protocol + SPLIT_CHAR);
        return hadoopConf;
    }

    private String formatKey(String protocol, String key) {
        return String.format(S3_FORMAT_KEY, protocol, key);
    }
}

