/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.split;

import java.io.Serializable;
import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;

public class SplitTransformConfig
implements Serializable {
    public static final Option<String> KEY_SEPARATOR = Options.key((String)"separator").stringType().noDefaultValue().withDescription("The separator to split the field");
    public static final Option<String> KEY_SPLIT_FIELD = Options.key((String)"split_field").stringType().noDefaultValue().withDescription("The field to be split");
    public static final Option<List<String>> KEY_OUTPUT_FIELDS = Options.key((String)"output_fields").listType().noDefaultValue().withDescription("The result fields after split");
    private String separator;
    private String splitField;
    private String[] outputFields;
    private String[] emptySplits;

    public static SplitTransformConfig of(ReadonlyConfig config) {
        SplitTransformConfig splitTransformConfig = new SplitTransformConfig();
        splitTransformConfig.setSeparator((String)config.get(KEY_SEPARATOR));
        splitTransformConfig.setSplitField((String)config.get(KEY_SPLIT_FIELD));
        splitTransformConfig.setOutputFields(((List)config.get(KEY_OUTPUT_FIELDS)).toArray(new String[0]));
        splitTransformConfig.setEmptySplits(new String[splitTransformConfig.getOutputFields().length]);
        return splitTransformConfig;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getSplitField() {
        return this.splitField;
    }

    public String[] getOutputFields() {
        return this.outputFields;
    }

    public String[] getEmptySplits() {
        return this.emptySplits;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setSplitField(String splitField) {
        this.splitField = splitField;
    }

    public void setOutputFields(String[] outputFields) {
        this.outputFields = outputFields;
    }

    public void setEmptySplits(String[] emptySplits) {
        this.emptySplits = emptySplits;
    }
}

