/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;

public class PhysicalColumn
extends Column {
    private static final long serialVersionUID = 1L;

    protected PhysicalColumn(String name, SeaTunnelDataType<?> dataType, Long columnLength, Integer scale) {
        super(name, dataType, columnLength, scale);
    }

    protected PhysicalColumn(String name, SeaTunnelDataType<?> dataType, Long columnLength, boolean nullable, Object defaultValue, String comment) {
        super(name, dataType, columnLength, nullable, defaultValue, comment);
    }

    public PhysicalColumn(String name, SeaTunnelDataType<?> dataType, Long columnLength, Integer scale, boolean nullable, Object defaultValue, String comment) {
        super(name, dataType, columnLength, scale, nullable, defaultValue, comment, null, new HashMap<String, Object>());
    }

    public PhysicalColumn(String name, SeaTunnelDataType<?> dataType, Long columnLength, boolean nullable, Object defaultValue, String comment, String sourceType, Map<String, Object> options) {
        super(name, dataType, columnLength, null, nullable, defaultValue, comment, sourceType, options);
    }

    public PhysicalColumn(String name, SeaTunnelDataType<?> dataType, Long columnLength, Integer scale, boolean nullable, Object defaultValue, String comment, String sourceType, Map<String, Object> options) {
        super(name, dataType, columnLength, scale, nullable, defaultValue, comment, sourceType, options);
    }

    @Deprecated
    protected PhysicalColumn(String name, SeaTunnelDataType<?> dataType, Integer columnLength, boolean nullable, Object defaultValue, String comment) {
        super(name, dataType, columnLength, nullable, defaultValue, comment);
    }

    @Deprecated
    protected PhysicalColumn(String name, SeaTunnelDataType<?> dataType, Integer columnLength, boolean nullable, Object defaultValue, String comment, String sourceType, boolean isUnsigned, boolean isZeroFill, Long bitLen, Long longColumnLength, Map<String, Object> options) {
        super(name, dataType, columnLength, nullable, defaultValue, comment, sourceType, isUnsigned, isZeroFill, bitLen, longColumnLength, options);
    }

    @Deprecated
    public PhysicalColumn(String name, SeaTunnelDataType<?> dataType, Long columnLength, Integer scale, boolean nullable, Object defaultValue, String comment, String sourceType, Map<String, Object> options, boolean isUnsigned, boolean isZeroFill, Long bitLen, Long longColumnLength) {
        super(name, dataType, columnLength, scale, nullable, defaultValue, comment, sourceType, options, isUnsigned, isZeroFill, bitLen, longColumnLength);
    }

    public static PhysicalColumn of(String name, SeaTunnelDataType<?> dataType, Long columnLength, boolean nullable, Object defaultValue, String comment) {
        return new PhysicalColumn(name, dataType, columnLength, nullable, defaultValue, comment);
    }

    public static PhysicalColumn of(String name, SeaTunnelDataType<?> dataType, Long columnLength, Integer scale, boolean nullable, Object defaultValue, String comment) {
        return new PhysicalColumn(name, dataType, columnLength, scale, nullable, defaultValue, comment);
    }

    public static PhysicalColumn of(String name, SeaTunnelDataType<?> dataType, Long columnLength, boolean nullable, Object defaultValue, String comment, String sourceType, Map<String, Object> options) {
        return new PhysicalColumn(name, dataType, columnLength, null, nullable, defaultValue, comment, sourceType, options);
    }

    @Deprecated
    public static PhysicalColumn of(String name, SeaTunnelDataType<?> dataType, Integer columnLength, boolean nullable, Object defaultValue, String comment) {
        return new PhysicalColumn(name, dataType, columnLength, nullable, defaultValue, comment);
    }

    @Deprecated
    public static PhysicalColumn of(String name, SeaTunnelDataType<?> dataType, Integer columnLength, boolean nullable, Object defaultValue, String comment, String sourceType, boolean isUnsigned, boolean isZeroFill, Long bitLen, Map<String, Object> options, Long longColumnLength) {
        return new PhysicalColumn(name, dataType, columnLength, nullable, defaultValue, comment, sourceType, isUnsigned, isZeroFill, bitLen, longColumnLength, options);
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    @Override
    public Column copy(SeaTunnelDataType<?> newType) {
        return new PhysicalColumn(this.name, newType, this.columnLength, this.scale, this.nullable, this.defaultValue, this.comment, this.sourceType, this.options, this.isUnsigned, this.isZeroFill, this.bitLen, this.longColumnLength);
    }

    @Override
    public Column copy() {
        return new PhysicalColumn(this.name, this.dataType, this.columnLength, this.scale, this.nullable, this.defaultValue, this.comment, this.sourceType, this.options, this.isUnsigned, this.isZeroFill, this.bitLen, this.longColumnLength);
    }

    @Override
    public Column rename(String newColumnName) {
        return new PhysicalColumn(newColumnName, this.dataType, this.columnLength, this.scale, this.nullable, this.defaultValue, this.comment, this.sourceType, this.options, this.isUnsigned, this.isZeroFill, this.bitLen, this.longColumnLength);
    }

    public static PhysicalColumnBuilder builder() {
        return new PhysicalColumnBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PhysicalColumn)) {
            return false;
        }
        PhysicalColumn other = (PhysicalColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PhysicalColumn;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "PhysicalColumn(super=" + super.toString() + ")";
    }

    public static class PhysicalColumnBuilder {
        private String name;
        private SeaTunnelDataType<?> dataType;
        private Long columnLength;
        private Integer scale;
        private boolean nullable;
        private Object defaultValue;
        private String comment;
        private String sourceType;
        private Map<String, Object> options;

        PhysicalColumnBuilder() {
        }

        public PhysicalColumnBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PhysicalColumnBuilder dataType(SeaTunnelDataType<?> dataType) {
            this.dataType = dataType;
            return this;
        }

        public PhysicalColumnBuilder columnLength(Long columnLength) {
            this.columnLength = columnLength;
            return this;
        }

        public PhysicalColumnBuilder scale(Integer scale) {
            this.scale = scale;
            return this;
        }

        public PhysicalColumnBuilder nullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public PhysicalColumnBuilder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public PhysicalColumnBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public PhysicalColumnBuilder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public PhysicalColumnBuilder options(Map<String, Object> options) {
            this.options = options;
            return this;
        }

        public PhysicalColumn build() {
            return new PhysicalColumn(this.name, this.dataType, this.columnLength, this.scale, this.nullable, this.defaultValue, this.comment, this.sourceType, this.options);
        }

        public String toString() {
            return "PhysicalColumn.PhysicalColumnBuilder(name=" + this.name + ", dataType=" + this.dataType + ", columnLength=" + this.columnLength + ", scale=" + this.scale + ", nullable=" + this.nullable + ", defaultValue=" + this.defaultValue + ", comment=" + this.comment + ", sourceType=" + this.sourceType + ", options=" + this.options + ")";
        }
    }
}

