/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raftop;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.IndeterminateOperationStateAware;
import com.hazelcast.cp.internal.RaftNodeAware;
import com.hazelcast.cp.internal.RaftOp;
import com.hazelcast.cp.internal.RaftServiceDataSerializerHook;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.RaftNode;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class GetInitialRaftGroupMembersIfCurrentGroupMemberOp
extends RaftOp
implements RaftNodeAware,
IndeterminateOperationStateAware,
IdentifiedDataSerializable {
    private RaftEndpoint endpoint;
    private RaftNode raftNode;

    public GetInitialRaftGroupMembersIfCurrentGroupMemberOp() {
    }

    public GetInitialRaftGroupMembersIfCurrentGroupMemberOp(RaftEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void setRaftNode(RaftNode raftNode) {
        this.raftNode = raftNode;
    }

    @Override
    public Object run(CPGroupId groupId, long commitIndex) {
        Preconditions.checkState(this.raftNode != null, "RaftNode is not injected in " + groupId);
        Collection<RaftEndpoint> members = this.raftNode.getAppliedMembers();
        Preconditions.checkState(members.contains(this.endpoint), this.endpoint + " is not in the current committed member list: " + members + " of " + groupId);
        return new ArrayList<RaftEndpoint>(this.raftNode.getInitialMembers());
    }

    @Override
    public boolean isRetryableOnIndeterminateOperationState() {
        return true;
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 36;
    }

    @Override
    protected String getServiceName() {
        return "hz:core:raft";
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.endpoint);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.endpoint = (RaftEndpoint)in.readObject();
    }
}

