/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.fake.source;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.fake.config.FakeConfig;
import org.apache.seatunnel.connectors.seatunnel.fake.exception.FakeConnectorException;
import org.apache.seatunnel.connectors.seatunnel.fake.utils.FakeDataRandomUtils;
import org.apache.seatunnel.format.json.JsonDeserializationSchema;

public class FakeDataGenerator {
    private final CatalogTable catalogTable;
    private final FakeConfig fakeConfig;
    private final JsonDeserializationSchema jsonDeserializationSchema;
    private final FakeDataRandomUtils fakeDataRandomUtils;
    private String tableId;

    public FakeDataGenerator(FakeConfig fakeConfig) {
        this.catalogTable = fakeConfig.getCatalogTable();
        this.tableId = this.catalogTable.getTableId().toTablePath().toString();
        this.fakeConfig = fakeConfig;
        this.jsonDeserializationSchema = fakeConfig.getFakeRows() == null ? null : new JsonDeserializationSchema(false, false, this.catalogTable.getSeaTunnelRowType());
        this.fakeDataRandomUtils = new FakeDataRandomUtils(fakeConfig);
    }

    private SeaTunnelRow convertRow(FakeConfig.RowData rowData) {
        try {
            SeaTunnelRow seaTunnelRow = this.jsonDeserializationSchema.deserialize(rowData.getFieldsJson());
            if (rowData.getKind() != null) {
                seaTunnelRow.setRowKind(RowKind.valueOf((String)rowData.getKind()));
            }
            seaTunnelRow.setTableId(this.tableId);
            return seaTunnelRow;
        }
        catch (IOException e) {
            throw CommonError.jsonOperationError((String)"Fake", (String)rowData.getFieldsJson(), (Throwable)e);
        }
    }

    private SeaTunnelRow randomRow() {
        SeaTunnelRowType rowType = this.catalogTable.getSeaTunnelRowType();
        String[] fieldNames = rowType.getFieldNames();
        SeaTunnelDataType[] fieldTypes = rowType.getFieldTypes();
        ArrayList<Object> randomRow = new ArrayList<Object>(fieldNames.length);
        for (SeaTunnelDataType fieldType : fieldTypes) {
            randomRow.add(this.randomColumnValue(fieldType));
        }
        SeaTunnelRow seaTunnelRow = new SeaTunnelRow(randomRow.toArray());
        seaTunnelRow.setTableId(this.tableId);
        return seaTunnelRow;
    }

    public List<SeaTunnelRow> generateFakedRows(int rowNum) {
        ArrayList<SeaTunnelRow> seaTunnelRows = new ArrayList<SeaTunnelRow>();
        if (this.fakeConfig.getFakeRows() != null) {
            for (FakeConfig.RowData rowData : this.fakeConfig.getFakeRows()) {
                seaTunnelRows.add(this.convertRow(rowData));
            }
        } else {
            for (int i = 0; i < rowNum; ++i) {
                seaTunnelRows.add(this.randomRow());
            }
        }
        return seaTunnelRows;
    }

    private Object randomColumnValue(SeaTunnelDataType<?> fieldType) {
        switch (fieldType.getSqlType()) {
            case ARRAY: {
                ArrayType arrayType = (ArrayType)fieldType;
                BasicType elementType = arrayType.getElementType();
                int length = this.fakeConfig.getArraySize();
                Object array = Array.newInstance(elementType.getTypeClass(), length);
                for (int i = 0; i < length; ++i) {
                    Object value = this.randomColumnValue((SeaTunnelDataType<?>)elementType);
                    Array.set(array, i, value);
                }
                return array;
            }
            case MAP: {
                MapType mapType = (MapType)fieldType;
                SeaTunnelDataType keyType = mapType.getKeyType();
                SeaTunnelDataType valueType = mapType.getValueType();
                HashMap<Object, Object> objectMap = new HashMap<Object, Object>();
                int mapSize = this.fakeConfig.getMapSize();
                for (int i = 0; i < mapSize; ++i) {
                    Object key = this.randomColumnValue(keyType);
                    Object value = this.randomColumnValue(valueType);
                    objectMap.put(key, value);
                }
                return objectMap;
            }
            case STRING: {
                return this.fakeDataRandomUtils.randomString();
            }
            case BOOLEAN: {
                return this.fakeDataRandomUtils.randomBoolean();
            }
            case TINYINT: {
                return this.fakeDataRandomUtils.randomTinyint();
            }
            case SMALLINT: {
                return this.fakeDataRandomUtils.randomSmallint();
            }
            case INT: {
                return this.fakeDataRandomUtils.randomInt();
            }
            case BIGINT: {
                return this.fakeDataRandomUtils.randomBigint();
            }
            case FLOAT: {
                return this.fakeDataRandomUtils.randomFloat();
            }
            case DOUBLE: {
                return this.fakeDataRandomUtils.randomDouble();
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)fieldType;
                return this.fakeDataRandomUtils.randomBigDecimal(decimalType.getPrecision(), decimalType.getScale());
            }
            case NULL: {
                return null;
            }
            case BYTES: {
                return this.fakeDataRandomUtils.randomBytes();
            }
            case DATE: {
                return this.fakeDataRandomUtils.randomLocalDate();
            }
            case TIME: {
                return this.fakeDataRandomUtils.randomLocalTime();
            }
            case TIMESTAMP: {
                return this.fakeDataRandomUtils.randomLocalDateTime();
            }
            case ROW: {
                SeaTunnelDataType[] fieldTypes = ((SeaTunnelRowType)fieldType).getFieldTypes();
                Object[] objects = new Object[fieldTypes.length];
                for (int i = 0; i < fieldTypes.length; ++i) {
                    Object object;
                    objects[i] = object = this.randomColumnValue(fieldTypes[i]);
                }
                return new SeaTunnelRow(objects);
            }
        }
        throw new FakeConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "SeaTunnel Fake source connector not support this data type");
    }
}

