/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.api.common.metrics.MetricsContext;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.common.utils.function.ConsumerWithException;
import org.apache.seatunnel.engine.common.utils.ExceptionUtil;
import org.apache.seatunnel.engine.core.checkpoint.InternalCheckpointListener;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.actions.ShuffleAction;
import org.apache.seatunnel.engine.core.dag.actions.SinkAction;
import org.apache.seatunnel.engine.core.dag.actions.SourceAction;
import org.apache.seatunnel.engine.core.dag.actions.TransformChainAction;
import org.apache.seatunnel.engine.core.dag.actions.UnknownActionException;
import org.apache.seatunnel.engine.core.job.ConnectorJarIdentifier;
import org.apache.seatunnel.engine.server.checkpoint.ActionStateKey;
import org.apache.seatunnel.engine.server.checkpoint.ActionSubtaskState;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointBarrier;
import org.apache.seatunnel.engine.server.checkpoint.operation.TaskAcknowledgeOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.TriggerSchemaChangeAfterCheckpointOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.TriggerSchemaChangeBeforeCheckpointOperation;
import org.apache.seatunnel.engine.server.dag.physical.config.IntermediateQueueConfig;
import org.apache.seatunnel.engine.server.dag.physical.config.SinkConfig;
import org.apache.seatunnel.engine.server.dag.physical.config.SourceConfig;
import org.apache.seatunnel.engine.server.dag.physical.flow.Flow;
import org.apache.seatunnel.engine.server.dag.physical.flow.IntermediateExecutionFlow;
import org.apache.seatunnel.engine.server.dag.physical.flow.PhysicalExecutionFlow;
import org.apache.seatunnel.engine.server.dag.physical.flow.UnknownFlowException;
import org.apache.seatunnel.engine.server.execution.TaskGroup;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.metrics.SeaTunnelMetricsContext;
import org.apache.seatunnel.engine.server.task.AbstractTask;
import org.apache.seatunnel.engine.server.task.SeaTunnelTransformCollector;
import org.apache.seatunnel.engine.server.task.flow.ActionFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.flow.FlowLifeCycle;
import org.apache.seatunnel.engine.server.task.flow.IntermediateQueueFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.flow.OneInputFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.flow.ShuffleSinkFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.flow.ShuffleSourceFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.flow.SinkFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.flow.SourceFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.flow.TransformFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.group.AbstractTaskGroupWithIntermediateQueue;
import org.apache.seatunnel.engine.server.task.record.Barrier;
import org.apache.seatunnel.engine.server.task.statemachine.SeaTunnelTaskState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SeaTunnelTask
extends AbstractTask {
    private static final Logger log = LoggerFactory.getLogger(SeaTunnelTask.class);
    private static final long serialVersionUID = 2604309561613784425L;
    protected volatile SeaTunnelTaskState currState;
    private final Flow executionFlow;
    protected FlowLifeCycle startFlowLifeCycle;
    protected List<FlowLifeCycle> allCycles;
    protected List<OneInputFlowLifeCycle<Record<?>>> outputs;
    protected List<CompletableFuture<Void>> flowFutures;
    protected final Map<Long, List<ActionSubtaskState>> checkpointStates = new ConcurrentHashMap<Long, List<ActionSubtaskState>>();
    private final Map<Long, Integer> cycleAcks = new ConcurrentHashMap<Long, Integer>();
    protected int indexID;
    private TaskGroup taskBelongGroup;
    private SeaTunnelMetricsContext metricsContext;

    public SeaTunnelTask(long jobID, TaskLocation taskID, int indexID, Flow executionFlow) {
        super(jobID, taskID);
        this.indexID = indexID;
        this.executionFlow = executionFlow;
        this.currState = SeaTunnelTaskState.CREATED;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.metricsContext = this.getExecutionContext().getOrCreateMetricsContext(this.taskLocation);
        this.currState = SeaTunnelTaskState.INIT;
        this.flowFutures = new ArrayList<CompletableFuture<Void>>();
        this.allCycles = new ArrayList<FlowLifeCycle>();
        this.startFlowLifeCycle = this.convertFlowToActionLifeCycle(this.executionFlow);
        for (FlowLifeCycle cycle : this.allCycles) {
            cycle.init();
        }
        CompletableFuture.allOf(this.flowFutures.toArray(new CompletableFuture[0])).whenComplete((s2, e) -> {
            this.closeCalled = true;
        });
    }

    protected void stateProcess() throws Exception {
        switch (this.currState) {
            case INIT: {
                this.currState = SeaTunnelTaskState.WAITING_RESTORE;
                this.reportTaskStatus(SeaTunnelTaskState.WAITING_RESTORE);
                break;
            }
            case WAITING_RESTORE: {
                if (this.restoreComplete.isDone()) {
                    for (FlowLifeCycle cycle : this.allCycles) {
                        cycle.open();
                    }
                    this.currState = SeaTunnelTaskState.READY_START;
                    this.reportTaskStatus(SeaTunnelTaskState.READY_START);
                    break;
                }
                Thread.sleep(100L);
                break;
            }
            case READY_START: {
                if (this.startCalled) {
                    this.currState = SeaTunnelTaskState.STARTING;
                    break;
                }
                Thread.sleep(100L);
                break;
            }
            case STARTING: {
                this.currState = SeaTunnelTaskState.RUNNING;
                break;
            }
            case RUNNING: {
                this.collect();
                if (!this.prepareCloseStatus) break;
                this.currState = SeaTunnelTaskState.PREPARE_CLOSE;
                break;
            }
            case PREPARE_CLOSE: {
                if (this.closeCalled) {
                    this.currState = SeaTunnelTaskState.CLOSED;
                    break;
                }
                Thread.sleep(100L);
                break;
            }
            case CLOSED: {
                this.close();
                this.progress.done();
                return;
            }
            case CANCELLING: {
                this.close();
                this.currState = SeaTunnelTaskState.CANCELED;
                this.progress.done();
                return;
            }
            default: {
                throw new IllegalArgumentException("Unknown Enumerator State: " + this.currState);
            }
        }
    }

    public void setTaskGroup(TaskGroup group) {
        this.taskBelongGroup = group;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FlowLifeCycle convertFlowToActionLifeCycle(@NonNull Flow flow) throws Exception {
        void var2_13;
        if (flow == null) {
            throw new NullPointerException("flow is marked non-null but is null");
        }
        ArrayList flowLifeCycles = new ArrayList();
        if (!flow.getNext().isEmpty()) {
            for (Flow f : flow.getNext()) {
                flowLifeCycles.add((OneInputFlowLifeCycle)this.convertFlowToActionLifeCycle(f));
            }
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.flowFutures.add(completableFuture);
        if (flow instanceof PhysicalExecutionFlow) {
            Flow f;
            f = (PhysicalExecutionFlow)flow;
            if (((PhysicalExecutionFlow)f).getAction() instanceof SourceAction) {
                SourceFlowLifeCycle<?, ?> sourceFlowLifeCycle = this.createSourceFlowLifeCycle((SourceAction)((PhysicalExecutionFlow)f).getAction(), (SourceConfig)((PhysicalExecutionFlow)f).getConfig(), completableFuture, this.getMetricsContext());
                this.outputs = flowLifeCycles;
            } else if (((PhysicalExecutionFlow)f).getAction() instanceof SinkAction) {
                SinkFlowLifeCycle sinkFlowLifeCycle = new SinkFlowLifeCycle((SinkAction)((PhysicalExecutionFlow)f).getAction(), this.taskLocation, this.indexID, this, ((SinkConfig)((PhysicalExecutionFlow)f).getConfig()).getCommitterTask(), ((SinkConfig)((PhysicalExecutionFlow)f).getConfig()).isContainCommitter(), completableFuture, this.getMetricsContext());
            } else if (((PhysicalExecutionFlow)f).getAction() instanceof TransformChainAction) {
                TransformFlowLifeCycle transformFlowLifeCycle = new TransformFlowLifeCycle((TransformChainAction)((PhysicalExecutionFlow)f).getAction(), this, new SeaTunnelTransformCollector(flowLifeCycles), completableFuture);
            } else {
                if (!(((PhysicalExecutionFlow)f).getAction() instanceof ShuffleAction)) throw new UnknownActionException((Action)((PhysicalExecutionFlow)f).getAction());
                ShuffleAction shuffleAction = (ShuffleAction)((PhysicalExecutionFlow)f).getAction();
                HazelcastInstance hazelcastInstance = this.getExecutionContext().getInstance();
                if (flow.getNext().isEmpty()) {
                    ShuffleSinkFlowLifeCycle shuffleSinkFlowLifeCycle = new ShuffleSinkFlowLifeCycle(this, this.indexID, shuffleAction, hazelcastInstance, completableFuture);
                } else {
                    ShuffleSourceFlowLifeCycle shuffleSourceFlowLifeCycle = new ShuffleSourceFlowLifeCycle(this, this.indexID, shuffleAction, hazelcastInstance, completableFuture);
                }
                this.outputs = flowLifeCycles;
            }
        } else {
            if (!(flow instanceof IntermediateExecutionFlow)) throw new UnknownFlowException(flow);
            IntermediateQueueConfig config = (IntermediateQueueConfig)((IntermediateExecutionFlow)flow).getConfig();
            IntermediateQueueFlowLifeCycle intermediateQueueFlowLifeCycle = new IntermediateQueueFlowLifeCycle(this, completableFuture, ((AbstractTaskGroupWithIntermediateQueue)this.taskBelongGroup).getQueueCache(config.getQueueID()));
            this.outputs = flowLifeCycles;
        }
        this.allCycles.add((FlowLifeCycle)var2_13);
        return var2_13;
    }

    protected abstract SourceFlowLifeCycle<?, ?> createSourceFlowLifeCycle(SourceAction<?, ?, ?> var1, SourceConfig var2, CompletableFuture<Void> var3, MetricsContext var4);

    protected abstract void collect() throws Exception;

    @Override
    public Set<URL> getJarsUrl() {
        return this.getFlowInfo((action, set) -> set.addAll(action.getJarUrls()));
    }

    @Override
    public Set<ConnectorJarIdentifier> getConnectorPluginJars() {
        return this.getFlowInfo((action, set) -> set.addAll(action.getConnectorJarIdentifiers()));
    }

    public Set<ActionStateKey> getActionStateKeys() {
        return this.getFlowInfo((action, set) -> set.add(ActionStateKey.of(action)));
    }

    private <T> Set<T> getFlowInfo(BiConsumer<Action, Set<T>> function) {
        ArrayList<Flow> now = new ArrayList<Flow>();
        now.add(this.executionFlow);
        HashSet result = new HashSet();
        while (!now.isEmpty()) {
            ArrayList next = new ArrayList();
            now.forEach(n -> {
                if (n instanceof PhysicalExecutionFlow) {
                    function.accept((Action)((PhysicalExecutionFlow)n).getAction(), result);
                }
                next.addAll(n.getNext());
            });
            now.clear();
            now.addAll(next);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.allCycles.parallelStream().forEach(flowLifeCycle -> {
            try {
                flowLifeCycle.close();
            }
            catch (IOException e) {
                log.error("Close FlowLifeCycle error.", e);
            }
        });
    }

    public void ack(Barrier barrier) {
        log.debug("seatunnel task ack barrier[{}]", (Object)this.taskLocation);
        Integer ackSize = this.cycleAcks.compute(barrier.getId(), (id, count) -> {
            int n;
            if (count == null) {
                n = 1;
            } else {
                count = count + 1;
                n = count;
            }
            return n;
        });
        if (ackSize.intValue() == this.allCycles.size()) {
            if (barrier.prepareClose()) {
                this.prepareCloseStatus = true;
                this.prepareCloseBarrierId.set(barrier.getId());
            }
            if (barrier.snapshot()) {
                this.getExecutionContext().sendToMaster(new TaskAcknowledgeOperation(this.taskLocation, (CheckpointBarrier)barrier, this.checkpointStates.remove(barrier.getId()))).join();
            }
        }
    }

    public InvocationFuture<Object> triggerSchemaChangeBeforeCheckpoint() {
        log.info("trigger schema-change-before checkpoint. jobID[{}], taskLocation[{}]", (Object)this.jobID, (Object)this.taskLocation);
        return this.getExecutionContext().sendToMaster(new TriggerSchemaChangeBeforeCheckpointOperation(this.taskLocation));
    }

    public InvocationFuture<Object> triggerSchemaChangeAfterCheckpoint() {
        log.info("trigger schema-change-after checkpoint. jobID[{}], taskLocation[{}]", (Object)this.jobID, (Object)this.taskLocation);
        return this.getExecutionContext().sendToMaster(new TriggerSchemaChangeAfterCheckpointOperation(this.taskLocation));
    }

    public void addState(Barrier barrier, ActionStateKey stateKey, List<byte[]> state) {
        List states = this.checkpointStates.computeIfAbsent(barrier.getId(), id -> new ArrayList());
        states.add(new ActionSubtaskState(stateKey, this.indexID, state));
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        this.notifyAllAction(listener -> listener.notifyCheckpointComplete(checkpointId));
        this.tryClose(checkpointId);
    }

    @Override
    public void notifyCheckpointAborted(long checkpointId) throws Exception {
        this.notifyAllAction(listener -> listener.notifyCheckpointAborted(checkpointId));
        this.tryClose(checkpointId);
    }

    @Override
    public void notifyCheckpointEnd(long checkpointId) throws Exception {
        this.notifyAllAction(listener -> listener.notifyCheckpointEnd(checkpointId));
        this.tryClose(checkpointId);
    }

    public void notifyAllAction(ConsumerWithException<InternalCheckpointListener> consumer) {
        this.allCycles.stream().filter(cycle -> cycle instanceof InternalCheckpointListener).map(cycle -> (InternalCheckpointListener)((Object)cycle)).forEach(listener -> ExceptionUtil.sneaky(consumer, listener));
    }

    @Override
    public void restoreState(List<ActionSubtaskState> actionStateList) throws Exception {
        log.debug("restoreState for SeaTunnelTask[{}]", (Object)actionStateList);
        if (null == actionStateList) {
            log.debug("restoreState is null, do nothing!");
            return;
        }
        Map stateMap = actionStateList.stream().collect(Collectors.groupingBy(ActionSubtaskState::getStateKey, Collectors.toList()));
        this.allCycles.stream().filter(cycle -> cycle instanceof ActionFlowLifeCycle).map(cycle -> (ActionFlowLifeCycle)cycle).forEach(actionFlowLifeCycle -> {
            try {
                actionFlowLifeCycle.restoreState(stateMap.getOrDefault(ActionStateKey.of(actionFlowLifeCycle.getAction()), Collections.emptyList()));
            }
            catch (Exception e) {
                ExceptionUtil.sneakyThrow(e);
            }
        });
        this.restoreComplete.complete(null);
        log.debug("restoreState for SeaTunnelTask finished, actionStateList: {}", (Object)actionStateList);
    }

    @Override
    public SeaTunnelMetricsContext getMetricsContext() {
        return this.metricsContext;
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        if (null != this.metricsContext) {
            this.metricsContext.provideDynamicMetrics(descriptor.copy().withTag("taskName", this.getClass().getSimpleName()), context);
        }
    }
}

