/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.splitbrainprotection.impl;

import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.IcmpFailureDetectorConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.internal.cluster.fd.PingFailureDetector;
import com.hazelcast.splitbrainprotection.PingAware;

public abstract class AbstractPingAwareSplitBrainProtectionFunction
implements PingAware,
HazelcastInstanceAware,
MembershipListener {
    private boolean pingFDEnabled;
    private PingFailureDetector<Member> pingFailureDetector;

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        boolean icmpParallelMode;
        Config config = hazelcastInstance.getConfig();
        IcmpFailureDetectorConfig icmpFailureDetectorConfig = ConfigAccessor.getActiveMemberNetworkConfig(config).getIcmpFailureDetectorConfig();
        boolean icmpEnabled = icmpFailureDetectorConfig != null && icmpFailureDetectorConfig.isEnabled();
        boolean bl = icmpParallelMode = icmpEnabled && icmpFailureDetectorConfig.isParallelMode();
        if (!icmpEnabled || !icmpParallelMode) {
            return;
        }
        int icmpMaxAttempts = icmpFailureDetectorConfig.getMaxAttempts();
        this.pingFailureDetector = new PingFailureDetector(icmpMaxAttempts);
        this.pingFDEnabled = true;
    }

    @Override
    public void onPingLost(Member member) {
        if (!this.pingFDEnabled) {
            return;
        }
        this.pingFailureDetector.logAttempt(member);
    }

    @Override
    public void onPingRestored(Member member) {
        if (!this.pingFDEnabled) {
            return;
        }
        this.pingFailureDetector.heartbeat(member);
    }

    @Override
    public void memberAdded(MembershipEvent membershipEvent) {
        if (this.pingFDEnabled) {
            this.pingFailureDetector.heartbeat(membershipEvent.getMember());
        }
    }

    @Override
    public void memberRemoved(MembershipEvent membershipEvent) {
        if (this.pingFDEnabled) {
            this.pingFailureDetector.remove(membershipEvent.getMember());
        }
    }

    protected boolean isAlivePerIcmp(Member member) {
        if (!this.pingFDEnabled || member.localMember()) {
            return true;
        }
        return this.pingFailureDetector.isAlive(member);
    }
}

