/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.admin.kadmin.local;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.KadminOption;
import org.apache.kerby.kerberos.kerb.identity.KrbIdentity;
import org.apache.kerby.kerberos.kerb.keytab.Keytab;
import org.apache.kerby.kerberos.kerb.keytab.KeytabEntry;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;

public final class AdminHelper {
    private AdminHelper() {
    }

    public static void exportKeytab(File keytabFile, KrbIdentity identity) throws KrbException {
        Keytab keytab = AdminHelper.createOrLoadKeytab(keytabFile);
        AdminHelper.exportToKeytab(keytab, identity);
        AdminHelper.storeKeytab(keytab, keytabFile);
    }

    public static void exportKeytab(File keytabFile, List<KrbIdentity> identities) throws KrbException {
        Keytab keytab = AdminHelper.createOrLoadKeytab(keytabFile);
        for (KrbIdentity identity : identities) {
            AdminHelper.exportToKeytab(keytab, identity);
        }
        AdminHelper.storeKeytab(keytab, keytabFile);
    }

    public static Keytab loadKeytab(File keytabFile) throws KrbException {
        Keytab keytab;
        try {
            keytab = Keytab.loadKeytab(keytabFile);
        }
        catch (IOException e) {
            throw new KrbException("Failed to load keytab", (Throwable)e);
        }
        return keytab;
    }

    public static Keytab createOrLoadKeytab(File keytabFile) throws KrbException {
        Keytab keytab;
        try {
            if (!keytabFile.exists()) {
                if (!keytabFile.createNewFile()) {
                    throw new KrbException("Failed to create keytab file " + keytabFile.getAbsolutePath());
                }
                keytab = new Keytab();
            } else {
                keytab = Keytab.loadKeytab(keytabFile);
            }
        }
        catch (IOException e) {
            throw new KrbException("Failed to load or create keytab " + keytabFile.getAbsolutePath(), (Throwable)e);
        }
        return keytab;
    }

    public static void exportToKeytab(Keytab keytab, KrbIdentity identity) throws KrbException {
        PrincipalName principal = identity.getPrincipal();
        KerberosTime timestamp = KerberosTime.now();
        for (EncryptionType encType : identity.getKeys().keySet()) {
            EncryptionKey ekey = identity.getKeys().get(encType);
            int keyVersion = ekey.getKvno();
            keytab.addEntry(new KeytabEntry(principal, timestamp, keyVersion, ekey));
        }
    }

    public static void storeKeytab(Keytab keytab, File keytabFile) throws KrbException {
        try {
            keytab.store(keytabFile);
        }
        catch (IOException e) {
            throw new KrbException("Failed to store keytab", (Throwable)e);
        }
    }

    public static void removeKeytabEntriesOf(File keytabFile, String principalName) throws KrbException {
        Keytab keytab = AdminHelper.loadKeytab(keytabFile);
        keytab.removeKeytabEntries(new PrincipalName(principalName));
        AdminHelper.storeKeytab(keytab, keytabFile);
    }

    static void removeKeytabEntriesOf(File keytabFile, String principalName, int kvno) throws KrbException {
        Keytab keytab = AdminHelper.loadKeytab(keytabFile);
        keytab.removeKeytabEntries(new PrincipalName(principalName), kvno);
        AdminHelper.storeKeytab(keytab, keytabFile);
    }

    public static void removeOldKeytabEntriesOf(File keytabFile, String principalName) throws KrbException {
        Keytab keytab = AdminHelper.loadKeytab(keytabFile);
        List<KeytabEntry> entries = keytab.getKeytabEntries(new PrincipalName(principalName));
        int maxKvno = 0;
        for (KeytabEntry entry : entries) {
            if (maxKvno >= entry.getKvno()) continue;
            maxKvno = entry.getKvno();
        }
        for (KeytabEntry entry : entries) {
            if (entry.getKvno() >= maxKvno) continue;
            keytab.removeKeytabEntry(entry);
        }
        AdminHelper.storeKeytab(keytab, keytabFile);
    }

    public static KrbIdentity createIdentity(String principal, KOptions kOptions) throws KrbException {
        KrbIdentity kid = new KrbIdentity(principal);
        kid.setCreatedTime(KerberosTime.now());
        if (kOptions.contains(KadminOption.EXPIRE)) {
            Date date = kOptions.getDateOption(KadminOption.EXPIRE);
            kid.setExpireTime(new KerberosTime(date.getTime()));
        } else {
            kid.setExpireTime(new KerberosTime(253402300799900L));
        }
        if (kOptions.contains(KadminOption.KVNO)) {
            kid.setKeyVersion(kOptions.getIntegerOption(KadminOption.KVNO));
        } else {
            kid.setKeyVersion(1);
        }
        kid.setDisabled(false);
        kid.setLocked(false);
        return kid;
    }

    public static void updateIdentity(KrbIdentity identity, KOptions kOptions) {
        if (kOptions.contains(KadminOption.EXPIRE)) {
            Date date = kOptions.getDateOption(KadminOption.EXPIRE);
            identity.setExpireTime(new KerberosTime(date.getTime()));
        }
        if (kOptions.contains(KadminOption.DISABLED)) {
            identity.setDisabled(kOptions.getBooleanOption(KadminOption.DISABLED, false));
        }
        if (kOptions.contains(KadminOption.LOCKED)) {
            identity.setLocked(kOptions.getBooleanOption(KadminOption.LOCKED, false));
        }
    }

    public static Pattern getPatternFromGlobPatternString(String globString) throws KrbException {
        Pattern pt;
        if (globString == null || globString.equals("")) {
            return null;
        }
        if (!Pattern.matches("^[0-9A-Za-z._/@*?\\[\\]\\-]+$", globString)) {
            throw new KrbException("Glob pattern string contains invalid character");
        }
        String patternString = globString;
        patternString = patternString.replaceAll("\\.", "\\\\.");
        patternString = patternString.replaceAll("\\?", ".");
        patternString = patternString.replaceAll("\\*", ".*");
        patternString = "^" + patternString + "$";
        try {
            pt = Pattern.compile(patternString);
        }
        catch (PatternSyntaxException e) {
            throw new KrbException("Invalid glob pattern string");
        }
        return pt;
    }
}

