/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.jsonpath;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.SeaTunnelDataTypeConvertorUtil;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.seatunnel.transform.exception.JsonPathTransformErrorCode;
import org.apache.seatunnel.transform.exception.TransformException;
import org.apache.seatunnel.transform.jsonpath.ColumnConfig;

public class JsonPathTransformConfig
implements Serializable {
    public static final Option<String> PATH = Options.key((String)"path").stringType().noDefaultValue().withDescription("JSONPath for Selecting Field from JSON.");
    public static final Option<String> SRC_FIELD = Options.key((String)"src_field").stringType().noDefaultValue().withDescription("JSON source field.");
    public static final Option<String> DEST_FIELD = Options.key((String)"dest_field").stringType().noDefaultValue().withDescription("output field.");
    public static final Option<String> DEST_TYPE = Options.key((String)"dest_type").stringType().defaultValue((Object)"string").withDescription("output field type,default string");
    public static final Option<List<Map<String, String>>> COLUMNS = Options.key((String)"columns").type((TypeReference)new TypeReference<List<Map<String, String>>>(){}).noDefaultValue().withDescription("columns");
    private final List<ColumnConfig> columnConfigs;

    public List<ColumnConfig> getColumnConfigs() {
        return this.columnConfigs;
    }

    public JsonPathTransformConfig(List<ColumnConfig> columnConfigs) {
        this.columnConfigs = columnConfigs;
    }

    public static JsonPathTransformConfig of(ReadonlyConfig config) {
        if (!config.toConfig().hasPath(COLUMNS.key())) {
            throw new TransformException((SeaTunnelErrorCode)JsonPathTransformErrorCode.COLUMNS_MUST_NOT_EMPTY, JsonPathTransformErrorCode.COLUMNS_MUST_NOT_EMPTY.getErrorMessage());
        }
        List columns = (List)config.get(COLUMNS);
        ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>(columns.size());
        for (Map map : columns) {
            JsonPathTransformConfig.checkColumnConfig(map);
            String path = (String)map.get(PATH.key());
            String srcField = (String)map.get(SRC_FIELD.key());
            String destField = (String)map.get(DEST_FIELD.key());
            String type = (String)map.getOrDefault(DEST_TYPE.key(), DEST_TYPE.defaultValue());
            SeaTunnelDataType dataType = SeaTunnelDataTypeConvertorUtil.deserializeSeaTunnelDataType((String)srcField, (String)type);
            ColumnConfig columnConfig = new ColumnConfig(path, srcField, destField, dataType);
            configs.add(columnConfig);
        }
        return new JsonPathTransformConfig(configs);
    }

    private static void checkColumnConfig(Map<String, String> map) {
        String path = map.get(PATH.key());
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new TransformException((SeaTunnelErrorCode)JsonPathTransformErrorCode.PATH_MUST_NOT_EMPTY, JsonPathTransformErrorCode.PATH_MUST_NOT_EMPTY.getErrorMessage());
        }
        String srcField = map.get(SRC_FIELD.key());
        if (StringUtils.isBlank((CharSequence)srcField)) {
            throw new TransformException((SeaTunnelErrorCode)JsonPathTransformErrorCode.SRC_FIELD_MUST_NOT_EMPTY, JsonPathTransformErrorCode.SRC_FIELD_MUST_NOT_EMPTY.getErrorMessage());
        }
        String destField = map.get(DEST_FIELD.key());
        if (StringUtils.isBlank((CharSequence)destField)) {
            throw new TransformException((SeaTunnelErrorCode)JsonPathTransformErrorCode.DEST_FIELD_MUST_NOT_EMPTY, JsonPathTransformErrorCode.DEST_FIELD_MUST_NOT_EMPTY.getErrorMessage());
        }
    }
}

