/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.common.multitablesink;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.serialization.DefaultSerializer;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkAggregatedCommitter;
import org.apache.seatunnel.api.sink.SinkCommitter;
import org.apache.seatunnel.api.sink.SinkCommonOptions;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.factory.MultiTableFactoryContext;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.common.multitablesink.MultiTableAggregatedCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.common.multitablesink.MultiTableCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.common.multitablesink.MultiTableSinkAggregatedCommitter;
import org.apache.seatunnel.connectors.seatunnel.common.multitablesink.MultiTableSinkCommitter;
import org.apache.seatunnel.connectors.seatunnel.common.multitablesink.MultiTableSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.common.multitablesink.MultiTableState;
import org.apache.seatunnel.connectors.seatunnel.common.multitablesink.SinkContextProxy;
import org.apache.seatunnel.connectors.seatunnel.common.multitablesink.SinkIdentifier;

public class MultiTableSink
implements SeaTunnelSink<SeaTunnelRow, MultiTableState, MultiTableCommitInfo, MultiTableAggregatedCommitInfo> {
    private final Map<String, SeaTunnelSink> sinks;
    private final int replicaNum;

    public MultiTableSink(MultiTableFactoryContext context) {
        this.sinks = context.getSinks();
        this.replicaNum = (Integer)context.getOptions().get(SinkCommonOptions.MULTI_TABLE_SINK_REPLICA);
    }

    public String getPluginName() {
        return "MultiTableSink";
    }

    public SinkWriter<SeaTunnelRow, MultiTableCommitInfo, MultiTableState> createWriter(SinkWriter.Context context) throws IOException {
        HashMap writers = new HashMap();
        for (int i = 0; i < this.replicaNum; ++i) {
            for (String tableIdentifier : this.sinks.keySet()) {
                SeaTunnelSink sink = this.sinks.get(tableIdentifier);
                int index = context.getIndexOfSubtask() * this.replicaNum + i;
                writers.put(SinkIdentifier.of(tableIdentifier, index), sink.createWriter((SinkWriter.Context)new SinkContextProxy(index, context)));
            }
        }
        return new MultiTableSinkWriter(writers, this.replicaNum);
    }

    public SinkWriter<SeaTunnelRow, MultiTableCommitInfo, MultiTableState> restoreWriter(SinkWriter.Context context, List<MultiTableState> states) throws IOException {
        HashMap writers = new HashMap();
        for (int i = 0; i < this.replicaNum; ++i) {
            for (String tableIdentifier : this.sinks.keySet()) {
                SeaTunnelSink sink = this.sinks.get(tableIdentifier);
                int index = context.getIndexOfSubtask() * this.replicaNum + i;
                SinkIdentifier sinkIdentifier = SinkIdentifier.of(tableIdentifier, index);
                List state = states.stream().map(multiTableState -> multiTableState.getStates().get(sinkIdentifier)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
                if (state.isEmpty()) {
                    writers.put(sinkIdentifier, sink.createWriter((SinkWriter.Context)new SinkContextProxy(index, context)));
                    continue;
                }
                writers.put(sinkIdentifier, sink.restoreWriter((SinkWriter.Context)new SinkContextProxy(index, context), state));
            }
        }
        return new MultiTableSinkWriter(writers, this.replicaNum);
    }

    public Optional<Serializer<MultiTableState>> getWriterStateSerializer() {
        return Optional.of(new DefaultSerializer());
    }

    public Optional<SinkCommitter<MultiTableCommitInfo>> createCommitter() throws IOException {
        HashMap committers = new HashMap();
        for (String tableIdentifier : this.sinks.keySet()) {
            SeaTunnelSink sink = this.sinks.get(tableIdentifier);
            sink.createCommitter().ifPresent(committer -> committers.put(tableIdentifier, (SinkCommitter)committer));
        }
        if (committers.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MultiTableSinkCommitter(committers));
    }

    public Optional<Serializer<MultiTableCommitInfo>> getCommitInfoSerializer() {
        return Optional.of(new DefaultSerializer());
    }

    public Optional<SinkAggregatedCommitter<MultiTableCommitInfo, MultiTableAggregatedCommitInfo>> createAggregatedCommitter() throws IOException {
        HashMap aggCommitters = new HashMap();
        for (String tableIdentifier : this.sinks.keySet()) {
            SeaTunnelSink sink = this.sinks.get(tableIdentifier);
            Optional sinkOptional = sink.createAggregatedCommitter();
            sinkOptional.ifPresent(sinkAggregatedCommitter -> aggCommitters.put(tableIdentifier, (SinkAggregatedCommitter<?, ?>)sinkAggregatedCommitter));
        }
        if (aggCommitters.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MultiTableSinkAggregatedCommitter(aggCommitters));
    }

    public Optional<Serializer<MultiTableAggregatedCommitInfo>> getAggregatedCommitInfoSerializer() {
        return Optional.of(new DefaultSerializer());
    }

    public void setJobContext(JobContext jobContext) {
        this.sinks.values().forEach(sink -> sink.setJobContext(jobContext));
    }
}

