/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.checkpoint.storage.localfile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.engine.checkpoint.storage.PipelineState;
import org.apache.seatunnel.engine.checkpoint.storage.api.AbstractCheckpointStorage;
import org.apache.seatunnel.engine.checkpoint.storage.exception.CheckpointStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileStorage
extends AbstractCheckpointStorage {
    private static final Logger log = LoggerFactory.getLogger(LocalFileStorage.class);
    private static final String[] FILE_EXTENSIONS = new String[]{"ser"};
    private static final String DEFAULT_WINDOWS_OS_NAME_SPACE = "C:\\ProgramData\\seatunnel\\checkpoint\\";
    private static final String DEFAULT_LINUX_OS_NAME_SPACE = "/tmp/seatunnel/checkpoint/";

    public LocalFileStorage(Map<String, String> configuration) {
        this.initStorage(configuration);
    }

    @Override
    public void initStorage(Map<String, String> configuration) {
        if (MapUtils.isEmpty(configuration)) {
            this.setDefaultStorageSpaceByOSName();
            return;
        }
        if (StringUtils.isNotBlank(configuration.get("namespace"))) {
            this.setStorageNameSpace(configuration.get("namespace"));
        }
    }

    private void setDefaultStorageSpaceByOSName() {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            this.setStorageNameSpace(DEFAULT_WINDOWS_OS_NAME_SPACE);
        } else {
            this.setStorageNameSpace(DEFAULT_LINUX_OS_NAME_SPACE);
        }
    }

    @Override
    public String storeCheckPoint(PipelineState state) throws CheckpointStorageException {
        byte[] datas;
        try {
            datas = this.serializeCheckPointData(state);
        }
        catch (IOException e) {
            throw new CheckpointStorageException("Failed to serialize checkpoint data", e);
        }
        String fileName = this.getStorageParentDirectory() + state.getJobId() + File.separator + this.getCheckPointName(state);
        File file = new File(fileName);
        try {
            FileUtils.touch(file);
        }
        catch (IOException e) {
            throw new CheckpointStorageException("Failed to create checkpoint file " + fileName, e);
        }
        try {
            FileUtils.writeByteArrayToFile(file, datas);
        }
        catch (IOException e) {
            throw new CheckpointStorageException("Failed to write checkpoint data to file " + fileName, e);
        }
        return fileName;
    }

    @Override
    public List<PipelineState> getAllCheckpoints(String jobId) throws CheckpointStorageException {
        Collection<File> fileList;
        File filePath = new File(this.getStorageParentDirectory() + jobId);
        if (!filePath.exists()) {
            return new ArrayList<PipelineState>();
        }
        try {
            fileList = FileUtils.listFiles(filePath, FILE_EXTENSIONS, true);
        }
        catch (Exception e) {
            throw new CheckpointStorageException("Failed to get all checkpoints for job " + jobId, e);
        }
        if (fileList.isEmpty()) {
            return new ArrayList<PipelineState>();
        }
        ArrayList<PipelineState> states = new ArrayList<PipelineState>();
        fileList.forEach(file -> {
            try {
                byte[] data = FileUtils.readFileToByteArray(file);
                states.add(this.deserializeCheckPointData(data));
            }
            catch (IOException e) {
                log.error("Failed to read checkpoint data from file " + file.getAbsolutePath(), e);
            }
        });
        return states;
    }

    @Override
    public List<PipelineState> getLatestCheckpoint(String jobId) throws CheckpointStorageException {
        Collection<File> fileList = FileUtils.listFiles(new File(this.getStorageParentDirectory() + jobId), FILE_EXTENSIONS, false);
        if (fileList.isEmpty()) {
            throw new CheckpointStorageException("No checkpoint found for job " + jobId);
        }
        Map fileMap = fileList.stream().collect(Collectors.toMap(File::getName, Function.identity(), (v1, v2) -> v2));
        Set<String> latestPipelines = this.getLatestPipelineNames(fileMap.keySet());
        ArrayList<PipelineState> latestPipelineFiles = new ArrayList<PipelineState>(latestPipelines.size());
        latestPipelines.forEach(fileName -> {
            File file = (File)fileMap.get(fileName);
            try {
                byte[] data = FileUtils.readFileToByteArray(file);
                latestPipelineFiles.add(this.deserializeCheckPointData(data));
            }
            catch (IOException e) {
                log.error("Failed to read checkpoint data from file " + file.getAbsolutePath(), e);
            }
        });
        if (latestPipelineFiles.isEmpty()) {
            throw new CheckpointStorageException("Failed to read checkpoint data from file");
        }
        return latestPipelineFiles;
    }

    @Override
    public PipelineState getLatestCheckpointByJobIdAndPipelineId(String jobId, String pipelineId) throws CheckpointStorageException {
        String parentPath = this.getStorageParentDirectory() + jobId;
        Collection<File> fileList = FileUtils.listFiles(new File(parentPath), FILE_EXTENSIONS, false);
        if (fileList.isEmpty()) {
            throw new CheckpointStorageException("No checkpoint found for job " + jobId);
        }
        List<String> fileNames = fileList.stream().map(File::getName).collect(Collectors.toList());
        String latestFileName = this.getLatestCheckpointFileNameByJobIdAndPipelineId(fileNames, pipelineId);
        AtomicReference<Object> latestFile = new AtomicReference<Object>(null);
        fileList.forEach(file -> {
            String fileName = file.getName();
            if (fileName.equals(latestFileName)) {
                try {
                    byte[] data = FileUtils.readFileToByteArray(file);
                    latestFile.set(this.deserializeCheckPointData(data));
                }
                catch (IOException e) {
                    log.error("read checkpoint data from file " + file.getAbsolutePath(), e);
                }
            }
        });
        if (latestFile.get() == null) {
            throw new CheckpointStorageException("Failed to read checkpoint data from file, file name " + latestFileName);
        }
        return latestFile.get();
    }

    @Override
    public List<PipelineState> getCheckpointsByJobIdAndPipelineId(String jobId, String pipelineId) throws CheckpointStorageException {
        Collection<File> fileList = FileUtils.listFiles(new File(this.getStorageParentDirectory() + jobId), FILE_EXTENSIONS, false);
        if (fileList.isEmpty()) {
            throw new CheckpointStorageException("No checkpoint found for job " + jobId);
        }
        ArrayList<PipelineState> pipelineStates = new ArrayList<PipelineState>();
        fileList.forEach(file -> {
            String filePipelineId = this.getPipelineIdByFileName(file.getName());
            if (pipelineId.equals(filePipelineId)) {
                try {
                    byte[] data = FileUtils.readFileToByteArray(file);
                    pipelineStates.add(this.deserializeCheckPointData(data));
                }
                catch (IOException e) {
                    log.error("Failed to read checkpoint data from file " + file.getAbsolutePath(), e);
                }
            }
        });
        return pipelineStates;
    }

    @Override
    public void deleteCheckpoint(String jobId) {
        String jobPath = this.getStorageParentDirectory() + jobId;
        File file = new File(jobPath);
        try {
            FileUtils.deleteDirectory(file);
        }
        catch (IOException e) {
            log.warn("Failed to delete checkpoint directory " + jobPath, e);
        }
    }

    @Override
    public PipelineState getCheckpoint(String jobId, String pipelineId, String checkpointId) throws CheckpointStorageException {
        Collection<File> fileList = FileUtils.listFiles(new File(this.getStorageParentDirectory() + jobId), FILE_EXTENSIONS, false);
        if (fileList.isEmpty()) {
            throw new CheckpointStorageException("No checkpoint found for job " + jobId);
        }
        for (File file : fileList) {
            String fileName = file.getName();
            if (!pipelineId.equals(this.getPipelineIdByFileName(fileName)) || !checkpointId.equals(this.getCheckpointIdByFileName(fileName))) continue;
            try {
                byte[] data = FileUtils.readFileToByteArray(file);
                return this.deserializeCheckPointData(data);
            }
            catch (Exception e) {
                log.error("Failed to delete checkpoint {} for job {}, pipeline {}", checkpointId, jobId, pipelineId, e);
            }
        }
        throw new CheckpointStorageException(String.format("No checkpoint found, job(%s), pipeline(%s), checkpoint(%s)", jobId, pipelineId, checkpointId));
    }

    @Override
    public void deleteCheckpoint(String jobId, String pipelineId, String checkpointId) throws CheckpointStorageException {
        Collection<File> fileList = FileUtils.listFiles(new File(this.getStorageParentDirectory() + jobId), FILE_EXTENSIONS, false);
        if (fileList.isEmpty()) {
            throw new CheckpointStorageException("No checkpoint found for job " + jobId);
        }
        fileList.forEach(file -> {
            String fileName = file.getName();
            if (pipelineId.equals(this.getPipelineIdByFileName(fileName)) && checkpointId.equals(this.getCheckpointIdByFileName(fileName))) {
                try {
                    FileUtils.delete(file);
                }
                catch (Exception e) {
                    log.error("Failed to delete checkpoint {} for job {}, pipeline {}", checkpointId, jobId, pipelineId, e);
                }
            }
        });
    }
}

