/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static List<URL> searchJarFiles(@NonNull Path directory) throws IOException {
        if (directory == null) {
            throw new NullPointerException("directory is marked @NonNull but is null");
        }
        try (Stream<Path> paths = Files.walk(directory, FileVisitOption.FOLLOW_LINKS);){
            List<URL> list = paths.filter(path -> path.toString().endsWith(".jar")).map(path -> {
                try {
                    return path.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new SeaTunnelException(e);
                }
            }).collect(Collectors.toList());
            return list;
        }
    }

    public static String readFileToStr(Path path) {
        try {
            byte[] bytes = Files.readAllBytes(path);
            return new String(bytes);
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getMessage(e));
            throw new SeaTunnelException(e);
        }
    }

    public static void writeStringToFile(String filePath, String str) {
        try (PrintStream ps = null;){
            File file = new File(filePath);
            ps = new PrintStream(new FileOutputStream(file));
            ps.println(str);
        }
    }

    public static void createParentFile(File file) {
        File parentFile = file.getParentFile();
        if (null != parentFile && !parentFile.exists()) {
            parentFile.mkdirs();
            FileUtils.createParentFile(parentFile);
        }
    }

    public static void createNewFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        if (!file.getParentFile().exists()) {
            FileUtils.createParentFile(file);
        }
    }

    public static Long getFileLineNumber(@NonNull String filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked @NonNull but is null");
        }
        try {
            return Files.lines(Paths.get(filePath, new String[0])).count();
        }
        catch (IOException e) {
            throw new SeaTunnelException(String.format("get file[%s] line error", filePath), e);
        }
    }

    public static Long getFileLineNumberFromDir(@NonNull String dirPath) {
        if (dirPath == null) {
            throw new NullPointerException("dirPath is marked @NonNull but is null");
        }
        File file = new File(dirPath);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return 0L;
            }
            return Arrays.stream(files).map(currFile -> {
                if (currFile.isDirectory()) {
                    return FileUtils.getFileLineNumberFromDir(currFile.getPath());
                }
                return FileUtils.getFileLineNumber(currFile.getPath());
            }).mapToLong(Long::longValue).sum();
        }
        return FileUtils.getFileLineNumber(file.getPath());
    }

    public static void createNewDir(@NonNull String dirPath) {
        if (dirPath == null) {
            throw new NullPointerException("dirPath is marked @NonNull but is null");
        }
        FileUtils.deleteFile(dirPath);
        File file = new File(dirPath);
        file.mkdirs();
    }

    public static void deleteFile(@NonNull String filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked @NonNull but is null");
        }
        File file = new File(filePath);
        if (file.exists()) {
            if (file.isDirectory()) {
                FileUtils.deleteFiles(file);
            }
            file.delete();
        }
    }

    private static void deleteFiles(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        try {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File thisFile = files[i];
                if (thisFile.isDirectory()) {
                    FileUtils.deleteFiles(thisFile);
                }
                thisFile.delete();
            }
            file.delete();
        }
        catch (Exception e) {
            log.error("delete file [" + file.getPath() + "] error");
            throw new SeaTunnelException(e);
        }
    }
}

