/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.dag.execution;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.engine.common.utils.IdGenerator;
import org.apache.seatunnel.engine.core.dag.actions.AbstractAction;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.actions.PartitionTransformAction;
import org.apache.seatunnel.engine.core.dag.actions.SinkAction;
import org.apache.seatunnel.engine.core.dag.actions.SourceAction;
import org.apache.seatunnel.engine.core.dag.actions.TransformAction;
import org.apache.seatunnel.engine.core.dag.actions.TransformChainAction;
import org.apache.seatunnel.engine.core.dag.actions.UnknownActionException;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.dag.logical.LogicalEdge;
import org.apache.seatunnel.engine.core.dag.logical.LogicalVertex;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.server.dag.execution.ExecutionEdge;
import org.apache.seatunnel.engine.server.dag.execution.ExecutionPlan;
import org.apache.seatunnel.engine.server.dag.execution.ExecutionVertex;
import org.apache.seatunnel.engine.server.dag.execution.PipelineGenerator;

public class ExecutionPlanGenerator {
    private final IdGenerator idGenerator = new IdGenerator();
    private final Map<Long, ExecutionVertex> executionVertexMap = new HashMap<Long, ExecutionVertex>();
    private final Map<Long, List<LogicalVertex>> inputVerticesMap = new HashMap<Long, List<LogicalVertex>>();
    private final Map<Long, List<LogicalVertex>> targetVerticesMap = new HashMap<Long, List<LogicalVertex>>();
    private final Map<Long, Long> logicalToExecutionMap = new HashMap<Long, Long>();
    private final List<LogicalEdge> logicalEdges;
    private final List<LogicalVertex> logicalVertices;
    private final JobImmutableInformation jobImmutableInformation;
    private final long initializationTimestamp;

    public ExecutionPlanGenerator(@NonNull LogicalDag logicalPlan, @NonNull JobImmutableInformation jobImmutableInformation, long initializationTimestamp) {
        if (logicalPlan == null) {
            throw new NullPointerException("logicalPlan is marked @NonNull but is null");
        }
        if (jobImmutableInformation == null) {
            throw new NullPointerException("jobImmutableInformation is marked @NonNull but is null");
        }
        Preconditions.checkArgument(logicalPlan.getEdges().size() > 0, "ExecutionPlan Builder must have LogicalPlan.");
        this.logicalEdges = new ArrayList<LogicalEdge>(logicalPlan.getEdges());
        this.logicalVertices = new ArrayList<LogicalVertex>(logicalPlan.getLogicalVertexMap().values());
        this.jobImmutableInformation = jobImmutableInformation;
        this.initializationTimestamp = initializationTimestamp;
    }

    public ExecutionPlan generate() {
        this.fillVerticesMap();
        this.getSourceVertices().forEach(sourceVertex -> {
            ArrayList<LogicalVertex> vertices = new ArrayList<LogicalVertex>();
            vertices.add((LogicalVertex)sourceVertex);
            for (int index = 0; index < vertices.size(); ++index) {
                LogicalVertex vertex = (LogicalVertex)vertices.get(index);
                this.createExecutionVertex(vertex);
                if (!this.targetVerticesMap.containsKey(vertex.getVertexId())) continue;
                vertices.addAll((Collection)this.targetVerticesMap.get(vertex.getVertexId()));
            }
        });
        List<ExecutionEdge> executionEdges = this.createExecutionEdges();
        return new ExecutionPlan(new PipelineGenerator(this.executionVertexMap.values(), executionEdges).generatePipelines(), this.jobImmutableInformation);
    }

    public List<ExecutionEdge> createExecutionEdges() {
        return this.logicalEdges.stream().map(logicalEdge -> new ExecutionEdge(this.executionVertexMap.get(this.logicalToExecutionMap.get(logicalEdge.getInputVertexId())), this.executionVertexMap.get(this.logicalToExecutionMap.get(logicalEdge.getTargetVertexId())))).collect(Collectors.toList());
    }

    private void fillVerticesMap() {
        this.logicalEdges.forEach(logicalEdge -> {
            this.inputVerticesMap.computeIfAbsent(logicalEdge.getTargetVertexId(), id -> new ArrayList()).add(logicalEdge.getInputVertex());
            this.targetVerticesMap.computeIfAbsent(logicalEdge.getInputVertexId(), id -> new ArrayList()).add(logicalEdge.getTargetVertex());
        });
    }

    private List<LogicalVertex> getSourceVertices() {
        ArrayList<LogicalVertex> sourceVertices = new ArrayList<LogicalVertex>();
        for (LogicalVertex logicalVertex : this.logicalVertices) {
            List<LogicalVertex> inputVertices = this.inputVerticesMap.get(logicalVertex.getVertexId());
            if (inputVertices != null && inputVertices.size() != 0) continue;
            sourceVertices.add(logicalVertex);
        }
        return sourceVertices;
    }

    private void createExecutionVertex(LogicalVertex logicalVertex) {
        TransformChainAction newAction;
        if (this.logicalToExecutionMap.containsKey(logicalVertex.getVertexId())) {
            return;
        }
        ArrayList<LogicalVertex> chainedVertices = new ArrayList<LogicalVertex>();
        this.findChainedVertices(logicalVertex, chainedVertices);
        long newId = this.idGenerator.getNextId();
        if (chainedVertices.size() < 1) {
            newAction = ExecutionPlanGenerator.recreateAction(logicalVertex.getAction(), newId, logicalVertex.getParallelism());
        } else {
            ArrayList transforms = new ArrayList(chainedVertices.size());
            ArrayList names = new ArrayList(chainedVertices.size());
            HashSet<URL> jars = new HashSet<URL>();
            chainedVertices.stream().peek(vertex -> this.logicalToExecutionMap.put(vertex.getVertexId(), newId)).map(LogicalVertex::getAction).map(action -> (TransformAction)action).forEach(action -> {
                transforms.add(action.getTransform());
                jars.addAll(action.getJarUrls());
                names.add(action.getName());
            });
            newAction = new TransformChainAction(newId, String.join((CharSequence)"->", names), jars, transforms);
            newAction.setParallelism(logicalVertex.getAction().getParallelism());
        }
        ExecutionVertex executionVertex = new ExecutionVertex(newId, newAction, logicalVertex.getParallelism());
        this.executionVertexMap.put(newId, executionVertex);
        this.logicalToExecutionMap.put(logicalVertex.getVertexId(), executionVertex.getVertexId());
    }

    public static Action recreateAction(Action action, Long id, int parallelism) {
        AbstractAction newAction;
        if (action instanceof PartitionTransformAction) {
            newAction = new PartitionTransformAction((long)id, action.getName(), ((PartitionTransformAction)action).getPartitionTransformation(), action.getJarUrls());
        } else if (action instanceof SinkAction) {
            newAction = new SinkAction((long)id, action.getName(), ((SinkAction)action).getSink(), action.getJarUrls());
        } else if (action instanceof SourceAction) {
            newAction = new SourceAction((long)id, action.getName(), ((SourceAction)action).getSource(), action.getJarUrls());
        } else if (action instanceof TransformChainAction) {
            newAction = new TransformChainAction((long)id, action.getName(), action.getJarUrls(), ((TransformChainAction)action).getTransforms());
        } else {
            throw new UnknownActionException(action);
        }
        newAction.setParallelism(parallelism);
        return newAction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void findChainedVertices(LogicalVertex logicalVertex, List<LogicalVertex> chainedVertices) {
        Action action = logicalVertex.getAction();
        if (!(action instanceof TransformAction)) return;
        if (chainedVertices.size() == 0) {
            chainedVertices.add(logicalVertex);
        } else {
            if (this.inputVerticesMap.get(logicalVertex.getVertexId()).size() != 1) return;
            this.logicalEdges.remove(new LogicalEdge(chainedVertices.get(chainedVertices.size() - 1), logicalVertex));
            chainedVertices.add(logicalVertex);
        }
        if (this.targetVerticesMap.get(logicalVertex.getVertexId()).size() != 1) return;
        this.findChainedVertices(this.targetVerticesMap.get(logicalVertex.getVertexId()).get(0), chainedVertices);
    }
}

