/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.client.job;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.common.config.Common;
import org.apache.seatunnel.engine.client.SeaTunnelHazelcastClient;
import org.apache.seatunnel.engine.client.job.ClientJobProxy;
import org.apache.seatunnel.engine.client.job.JobClient;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.common.utils.IdGenerator;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDagGenerator;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.parse.JobConfigParser;

public class JobExecutionEnvironment {
    private static final ILogger LOGGER = Logger.getLogger(JobExecutionEnvironment.class);
    private final JobConfig jobConfig;
    private final int maxParallelism = 1;
    private final List<Action> actions = new ArrayList<Action>();
    private final Set<URL> jarUrls = new HashSet<URL>();
    private final List<URL> commonPluginJars = new ArrayList<URL>();
    private final String jobFilePath;
    private final IdGenerator idGenerator;
    private final SeaTunnelHazelcastClient seaTunnelHazelcastClient;
    private final JobClient jobClient;

    public JobExecutionEnvironment(JobConfig jobConfig, String jobFilePath, SeaTunnelHazelcastClient seaTunnelHazelcastClient) {
        this.jobConfig = jobConfig;
        this.jobFilePath = jobFilePath;
        this.idGenerator = new IdGenerator();
        this.seaTunnelHazelcastClient = seaTunnelHazelcastClient;
        this.jobClient = new JobClient(seaTunnelHazelcastClient);
        this.jobConfig.setJobContext(new JobContext(this.jobClient.getNewJobId()));
        this.commonPluginJars.addAll(this.searchPluginJars());
        LOGGER.info("add common jar in plugins :" + this.commonPluginJars);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<URL> searchPluginJars() {
        try {
            if (!Files.exists(Common.pluginRootDir(), new LinkOption[0])) return Collections.emptySet();
            try (Stream<Path> paths = Files.walk(Common.pluginRootDir(), FileVisitOption.FOLLOW_LINKS);){
                Set<URL> set = paths.filter(path -> path.toString().endsWith(".jar")).map(path -> {
                    try {
                        return path.toUri().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new SeaTunnelEngineException(e);
                    }
                }).collect(Collectors.toSet());
                return set;
            }
        }
        catch (IOException | SeaTunnelEngineException e) {
            LOGGER.warning(String.format("Can't search plugin jars in %s.", Common.pluginRootDir()), e);
        }
        return Collections.emptySet();
    }

    private JobConfigParser getJobConfigParser() {
        return new JobConfigParser(this.jobFilePath, this.idGenerator, this.jobConfig, this.commonPluginJars);
    }

    public void addAction(List<Action> actions) {
        this.actions.addAll(actions);
    }

    private LogicalDagGenerator getLogicalDagGenerator() {
        return new LogicalDagGenerator(this.actions, this.jobConfig, this.idGenerator);
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public ClientJobProxy execute() throws ExecutionException, InterruptedException {
        JobImmutableInformation jobImmutableInformation = new JobImmutableInformation(Long.parseLong(this.jobConfig.getJobContext().getJobId()), (Data)this.seaTunnelHazelcastClient.getSerializationService().toData(this.getLogicalDag()), this.jobConfig, (List<URL>)new ArrayList<URL>(this.jarUrls));
        return this.jobClient.createJobProxy(jobImmutableInformation);
    }

    public LogicalDag getLogicalDag() {
        ImmutablePair<List<Action>, Set<URL>> immutablePair = this.getJobConfigParser().parse();
        this.actions.addAll((Collection<Action>)immutablePair.getLeft());
        this.jarUrls.addAll((Collection<URL>)immutablePair.getRight());
        return this.getLogicalDagGenerator().generate();
    }
}

