/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.impl.LongWordException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.TreeMap;

class MetricsDictionary {
    static final int MAX_WORD_LENGTH = 255;
    private TreeMap<String, Word> orderedDictionary = new TreeMap(Comparator.naturalOrder());

    MetricsDictionary() {
    }

    int getDictionaryId(String word) throws LongWordException {
        Objects.requireNonNull(word);
        if (word.length() > 255) {
            throw new LongWordException("Too long value in the metric descriptor found, maximum is 255: " + word);
        }
        int nextWordId = this.orderedDictionary.size();
        return this.orderedDictionary.computeIfAbsent(word, key -> new Word(word, nextWordId)).id;
    }

    public Collection<Word> words() {
        return this.orderedDictionary.values();
    }

    static final class Word {
        private String word;
        private int id;

        private Word(String word, int id) {
            this.word = word;
            this.id = id;
        }

        String word() {
            return this.word;
        }

        int dictionaryId() {
            return this.id;
        }

        public String toString() {
            return "Word{word='" + this.word + '\'' + ", id=" + this.id + '}';
        }
    }
}

