/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.samza.storage.kv;

import java.io.File;
import org.apache.samza.context.ContainerContext;
import org.apache.samza.context.JobContext;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.system.SystemStreamPartition;


/**
 * Used for testing {@link BaseKeyValueStorageEngineFactory}.
 * Implements {@link #getKVStore} to return a pre-built {@link KeyValueStore}.
 */
public class MockKeyValueStorageEngineFactory extends BaseKeyValueStorageEngineFactory<String, String> {
  private final KeyValueStore<byte[], byte[]> rawKeyValueStore;

  public MockKeyValueStorageEngineFactory(KeyValueStore<byte[], byte[]> rawKeyValueStore) {
    this.rawKeyValueStore = rawKeyValueStore;
  }

  @Override
  protected KeyValueStore<byte[], byte[]> getKVStore(String storeName, File storeDir, MetricsRegistry registry,
      SystemStreamPartition changeLogSystemStreamPartition, JobContext jobContext, ContainerContext containerContext,
      StoreMode storeMode) {
    return this.rawKeyValueStore;
  }
}
