/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.weblogger.webservices.adminprotocol.sdk;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import org.jdom.Document;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public abstract class Entry {
    protected static final Namespace NAMESPACE = Namespace.getNamespace((String)"http://purl.org/apache/roller/rap#");
    private String href = null;

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public abstract Document toDocument();

    public String toString() {
        StringWriter writer = new StringWriter();
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        try {
            outputter.output(this.toDocument(), (Writer)writer);
            ((Writer)writer).close();
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe.getMessage());
        }
        return ((Object)writer).toString();
    }

    public abstract String getType();

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Entry other = (Entry)o;
        if (!Entry.areEqual(this.getHref(), other.getHref())) {
            return false;
        }
        return Entry.areEqual(this.getType(), other.getType());
    }

    protected static boolean areEqual(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    protected static boolean areEqual(Object[] oa1, Object[] oa2) {
        return oa1 == null ? oa2 == null : Arrays.equals(oa1, oa2);
    }

    protected static interface Attributes {
        public static final String HREF = "href";
    }

    public static interface Types {
        public static final String USER = "user";
        public static final String WEBLOG = "weblog";
        public static final String MEMBER = "member";
        public static final String COLLECTION = "collection";
    }
}

