/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.acl.plain;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.acl.common.AclException;
import org.apache.rocketmq.acl.common.AclUtils;
import org.apache.rocketmq.acl.common.Permission;
import org.apache.rocketmq.acl.plain.PlainAccessResource;
import org.apache.rocketmq.acl.plain.RemoteAddressStrategy;
import org.apache.rocketmq.acl.plain.RemoteAddressStrategyFactory;
import org.apache.rocketmq.common.AclConfig;
import org.apache.rocketmq.common.DataVersion;
import org.apache.rocketmq.common.PlainAccessConfig;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.srvutil.AclFileWatchService;

public class PlainPermissionManager {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqCommon");
    private String fileHome = System.getProperty("rocketmq.home.dir", System.getenv("ROCKETMQ_HOME"));
    private String defaultAclDir = this.fileHome + File.separator + "conf" + File.separator + "acl";
    private String defaultAclFile = this.fileHome + File.separator + System.getProperty("rocketmq.acl.plain.file", "conf/plain_acl.yml");
    private Map<String, Map<String, PlainAccessResource>> aclPlainAccessResourceMap = new HashMap<String, Map<String, PlainAccessResource>>();
    private Map<String, String> accessKeyTable = new HashMap<String, String>();
    private List<RemoteAddressStrategy> globalWhiteRemoteAddressStrategy = new ArrayList<RemoteAddressStrategy>();
    private RemoteAddressStrategyFactory remoteAddressStrategyFactory = new RemoteAddressStrategyFactory();
    private Map<String, List<RemoteAddressStrategy>> globalWhiteRemoteAddressStrategyMap = new HashMap<String, List<RemoteAddressStrategy>>();
    private boolean isWatchStart;
    private Map<String, DataVersion> dataVersionMap = new HashMap<String, DataVersion>();
    @Deprecated
    private final DataVersion dataVersion = new DataVersion();
    private List<String> fileList = new ArrayList<String>();

    public PlainPermissionManager() {
        this.load();
        this.watch();
    }

    public List<String> getAllAclFiles(String path) {
        if (!new File(path).exists()) {
            log.info("The default acl dir {} is not exist", (Object)path);
            return new ArrayList<String>();
        }
        ArrayList<String> allAclFileFullPath = new ArrayList<String>();
        File file = new File(path);
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i].getAbsolutePath();
            File f = new File(fileName);
            if (fileName.equals(this.fileHome + "/conf/tools.yml")) continue;
            if (fileName.endsWith(".yml") || fileName.endsWith(".yaml")) {
                allAclFileFullPath.add(fileName);
                continue;
            }
            if (!f.isDirectory()) continue;
            allAclFileFullPath.addAll(this.getAllAclFiles(fileName));
        }
        return allAclFileFullPath;
    }

    public void load() {
        if (this.fileHome == null || this.fileHome.isEmpty()) {
            return;
        }
        HashMap<String, Map<String, PlainAccessResource>> aclPlainAccessResourceMap = new HashMap<String, Map<String, PlainAccessResource>>();
        HashMap<String, String> accessKeyTable = new HashMap<String, String>();
        ArrayList<RemoteAddressStrategy> globalWhiteRemoteAddressStrategy = new ArrayList<RemoteAddressStrategy>();
        HashMap<String, List<RemoteAddressStrategy>> globalWhiteRemoteAddressStrategyMap = new HashMap<String, List<RemoteAddressStrategy>>();
        HashMap<String, DataVersion> dataVersionMap = new HashMap<String, DataVersion>();
        this.fileList = this.getAllAclFiles(this.defaultAclDir);
        if (new File(this.defaultAclFile).exists() && !this.fileList.contains(this.defaultAclFile)) {
            this.fileList.add(this.defaultAclFile);
        }
        for (int i = 0; i < this.fileList.size(); ++i) {
            JSONObject plainAclConfData = AclUtils.getYamlDataObject(this.fileList.get(i), JSONObject.class);
            if (plainAclConfData == null || plainAclConfData.isEmpty()) {
                throw new AclException(String.format("%s file is not data", this.fileList.get(i)));
            }
            log.info("Broker plain acl conf data is : ", (Object)plainAclConfData.toString());
            ArrayList<RemoteAddressStrategy> globalWhiteRemoteAddressStrategyList = new ArrayList<RemoteAddressStrategy>();
            JSONArray globalWhiteRemoteAddressesList = plainAclConfData.getJSONArray("globalWhiteRemoteAddresses");
            if (globalWhiteRemoteAddressesList != null && !globalWhiteRemoteAddressesList.isEmpty()) {
                for (int j = 0; j < globalWhiteRemoteAddressesList.size(); ++j) {
                    globalWhiteRemoteAddressStrategyList.add(this.remoteAddressStrategyFactory.getRemoteAddressStrategy(globalWhiteRemoteAddressesList.getString(j)));
                }
            }
            if (globalWhiteRemoteAddressStrategyList.size() > 0) {
                globalWhiteRemoteAddressStrategyMap.put(this.fileList.get(i), globalWhiteRemoteAddressStrategyList);
                globalWhiteRemoteAddressStrategy.addAll(globalWhiteRemoteAddressStrategyList);
            }
            JSONArray accounts = plainAclConfData.getJSONArray("accounts");
            HashMap<String, PlainAccessResource> plainAccessResourceMap = new HashMap<String, PlainAccessResource>();
            if (accounts != null && !accounts.isEmpty()) {
                List plainAccessConfigList = accounts.toJavaList(PlainAccessConfig.class);
                for (PlainAccessConfig plainAccessConfig : plainAccessConfigList) {
                    PlainAccessResource plainAccessResource = this.buildPlainAccessResource(plainAccessConfig);
                    if (accessKeyTable.get(plainAccessResource.getAccessKey()) == null) {
                        plainAccessResourceMap.put(plainAccessResource.getAccessKey(), plainAccessResource);
                        accessKeyTable.put(plainAccessResource.getAccessKey(), this.fileList.get(i));
                        continue;
                    }
                    log.warn("The accesssKey {} is repeated in multiple ACL files", (Object)plainAccessResource.getAccessKey());
                }
            }
            if (plainAccessResourceMap.size() > 0) {
                aclPlainAccessResourceMap.put(this.fileList.get(i), plainAccessResourceMap);
            }
            JSONArray tempDataVersion = plainAclConfData.getJSONArray("dataVersion");
            DataVersion dataVersion = new DataVersion();
            if (tempDataVersion != null && !tempDataVersion.isEmpty()) {
                List dataVersions = tempDataVersion.toJavaList(DataVersion.class);
                DataVersion firstElement = (DataVersion)dataVersions.get(0);
                dataVersion.assignNewOne(firstElement);
            }
            dataVersionMap.put(this.fileList.get(i), dataVersion);
        }
        if (dataVersionMap.containsKey(this.defaultAclFile)) {
            this.dataVersion.assignNewOne((DataVersion)dataVersionMap.get(this.defaultAclFile));
        }
        this.dataVersionMap = dataVersionMap;
        this.globalWhiteRemoteAddressStrategyMap = globalWhiteRemoteAddressStrategyMap;
        this.globalWhiteRemoteAddressStrategy = globalWhiteRemoteAddressStrategy;
        this.aclPlainAccessResourceMap = aclPlainAccessResourceMap;
        this.accessKeyTable = accessKeyTable;
    }

    public void load(String aclFilePath) {
        JSONArray accounts;
        HashMap<String, PlainAccessResource> plainAccessResourceMap = new HashMap<String, PlainAccessResource>();
        ArrayList<RemoteAddressStrategy> globalWhiteRemoteAddressStrategy = new ArrayList<RemoteAddressStrategy>();
        JSONObject plainAclConfData = AclUtils.getYamlDataObject(aclFilePath, JSONObject.class);
        if (plainAclConfData == null || plainAclConfData.isEmpty()) {
            throw new AclException(String.format("%s file is not data", aclFilePath));
        }
        log.info("Broker plain acl conf data is : ", (Object)plainAclConfData.toString());
        JSONArray globalWhiteRemoteAddressesList = plainAclConfData.getJSONArray("globalWhiteRemoteAddresses");
        if (globalWhiteRemoteAddressesList != null && !globalWhiteRemoteAddressesList.isEmpty()) {
            for (int i = 0; i < globalWhiteRemoteAddressesList.size(); ++i) {
                globalWhiteRemoteAddressStrategy.add(this.remoteAddressStrategyFactory.getRemoteAddressStrategy(globalWhiteRemoteAddressesList.getString(i)));
            }
        }
        this.globalWhiteRemoteAddressStrategy.addAll(globalWhiteRemoteAddressStrategy);
        if (this.globalWhiteRemoteAddressStrategyMap.get(aclFilePath) != null) {
            List<RemoteAddressStrategy> remoteAddressStrategyList = this.globalWhiteRemoteAddressStrategyMap.get(aclFilePath);
            for (int i = 0; i < remoteAddressStrategyList.size(); ++i) {
                this.globalWhiteRemoteAddressStrategy.remove(remoteAddressStrategyList.get(i));
            }
            this.globalWhiteRemoteAddressStrategyMap.put(aclFilePath, globalWhiteRemoteAddressStrategy);
        }
        if ((accounts = plainAclConfData.getJSONArray("accounts")) != null && !accounts.isEmpty()) {
            List plainAccessConfigList = accounts.toJavaList(PlainAccessConfig.class);
            for (PlainAccessConfig plainAccessConfig : plainAccessConfigList) {
                PlainAccessResource plainAccessResource = this.buildPlainAccessResource(plainAccessConfig);
                if (this.accessKeyTable.get(plainAccessResource.getAccessKey()) != null) continue;
                plainAccessResourceMap.put(plainAccessResource.getAccessKey(), plainAccessResource);
                this.accessKeyTable.put(plainAccessResource.getAccessKey(), aclFilePath);
            }
        }
        JSONArray tempDataVersion = plainAclConfData.getJSONArray("dataVersion");
        DataVersion dataVersion = new DataVersion();
        if (tempDataVersion != null && !tempDataVersion.isEmpty()) {
            List dataVersions = tempDataVersion.toJavaList(DataVersion.class);
            DataVersion firstElement = (DataVersion)dataVersions.get(0);
            dataVersion.assignNewOne(firstElement);
        }
        this.aclPlainAccessResourceMap.put(aclFilePath, plainAccessResourceMap);
        this.dataVersionMap.put(aclFilePath, dataVersion);
        if (aclFilePath.equals(this.defaultAclFile)) {
            this.dataVersion.assignNewOne(dataVersion);
        }
    }

    @Deprecated
    public String getAclConfigDataVersion() {
        return this.dataVersion.toJson();
    }

    public Map<String, DataVersion> getDataVersionMap() {
        return this.dataVersionMap;
    }

    public Map<String, Object> updateAclConfigFileVersion(Map<String, Object> updateAclConfigMap) {
        List dataVersionList;
        Object dataVersions = updateAclConfigMap.get("dataVersion");
        DataVersion dataVersion = new DataVersion();
        if (dataVersions != null && (dataVersionList = (List)dataVersions).size() > 0) {
            dataVersion.setTimestamp(((Long)((Map)dataVersionList.get(0)).get("timestamp")).longValue());
            dataVersion.setCounter(new AtomicLong(Long.parseLong(((Map)dataVersionList.get(0)).get("counter").toString())));
        }
        dataVersion.nextVersion();
        ArrayList versionElement = new ArrayList();
        LinkedHashMap<String, Long> accountsMap = new LinkedHashMap<String, Long>();
        accountsMap.put("counter", dataVersion.getCounter().longValue());
        accountsMap.put("timestamp", dataVersion.getTimestamp());
        versionElement.add(accountsMap);
        updateAclConfigMap.put("dataVersion", versionElement);
        List accounts = (List)updateAclConfigMap.get("accounts");
        String accessKey = (String)((Map)accounts.get(0)).get("accessKey");
        String aclFileName = this.accessKeyTable.get(accessKey);
        this.dataVersionMap.put(aclFileName, dataVersion);
        return updateAclConfigMap;
    }

    public boolean updateAccessConfig(PlainAccessConfig plainAccessConfig) {
        HashMap<String, Object> aclAccessConfigMap;
        if (plainAccessConfig == null) {
            log.error("Parameter value plainAccessConfig is null,Please check your parameter");
            throw new AclException("Parameter value plainAccessConfig is null, Please check your parameter");
        }
        this.checkPlainAccessConfig(plainAccessConfig);
        Permission.checkResourcePerms(plainAccessConfig.getTopicPerms());
        Permission.checkResourcePerms(plainAccessConfig.getGroupPerms());
        if (this.accessKeyTable.containsKey(plainAccessConfig.getAccessKey())) {
            Map<String, PlainAccessResource> accountMap;
            Map<String, Object> updateAccountMap = null;
            String aclFileName = this.accessKeyTable.get(plainAccessConfig.getAccessKey());
            Map aclAccessConfigMap2 = AclUtils.getYamlDataObject(aclFileName, Map.class);
            List accounts = (List)aclAccessConfigMap2.get("accounts");
            for (Map account : accounts) {
                if (!account.get("accessKey").equals(plainAccessConfig.getAccessKey())) continue;
                accounts.remove(account);
                updateAccountMap = this.createAclAccessConfigMap(account, plainAccessConfig);
                accounts.add(updateAccountMap);
                aclAccessConfigMap2.put("accounts", accounts);
                break;
            }
            if ((accountMap = this.aclPlainAccessResourceMap.get(aclFileName)) == null) {
                accountMap = new HashMap<String, PlainAccessResource>(1);
                accountMap.put(plainAccessConfig.getAccessKey(), this.buildPlainAccessResource(plainAccessConfig));
            } else if (accountMap.size() == 0) {
                accountMap.put(plainAccessConfig.getAccessKey(), this.buildPlainAccessResource(plainAccessConfig));
            } else {
                for (Map.Entry<String, PlainAccessResource> entry : accountMap.entrySet()) {
                    if (!entry.getValue().equals(plainAccessConfig.getAccessKey())) continue;
                    PlainAccessResource plainAccessResource = this.buildPlainAccessResource(plainAccessConfig);
                    accountMap.put(entry.getKey(), plainAccessResource);
                    break;
                }
            }
            this.aclPlainAccessResourceMap.put(aclFileName, accountMap);
            return AclUtils.writeDataObject(aclFileName, this.updateAclConfigFileVersion(aclAccessConfigMap2));
        }
        String fileName = this.defaultAclFile;
        if (this.aclPlainAccessResourceMap.get(this.defaultAclFile) == null || this.aclPlainAccessResourceMap.get(this.defaultAclFile).size() == 0) {
            try {
                File defaultAclFile = new File(fileName);
                if (!defaultAclFile.exists()) {
                    defaultAclFile.createNewFile();
                }
            }
            catch (IOException e) {
                log.warn("create default acl file has exception when update accessConfig. ", (Throwable)e);
            }
        }
        if ((aclAccessConfigMap = AclUtils.getYamlDataObject(this.defaultAclFile, Map.class)) == null) {
            aclAccessConfigMap = new HashMap<String, Object>();
            aclAccessConfigMap.put("accounts", new ArrayList());
        }
        List accounts = (List)aclAccessConfigMap.get("accounts");
        accounts.add(this.createAclAccessConfigMap(null, plainAccessConfig));
        aclAccessConfigMap.put("accounts", accounts);
        this.accessKeyTable.put(plainAccessConfig.getAccessKey(), fileName);
        if (this.aclPlainAccessResourceMap.get(fileName) == null) {
            HashMap<String, PlainAccessResource> plainAccessResourceMap = new HashMap<String, PlainAccessResource>(1);
            plainAccessResourceMap.put(plainAccessConfig.getAccessKey(), this.buildPlainAccessResource(plainAccessConfig));
            this.aclPlainAccessResourceMap.put(fileName, plainAccessResourceMap);
        } else {
            Map<String, PlainAccessResource> plainAccessResourceMap = this.aclPlainAccessResourceMap.get(fileName);
            plainAccessResourceMap.put(plainAccessConfig.getAccessKey(), this.buildPlainAccessResource(plainAccessConfig));
            this.aclPlainAccessResourceMap.put(fileName, plainAccessResourceMap);
        }
        return AclUtils.writeDataObject(this.defaultAclFile, this.updateAclConfigFileVersion(aclAccessConfigMap));
    }

    public Map<String, Object> createAclAccessConfigMap(Map<String, Object> existedAccountMap, PlainAccessConfig plainAccessConfig) {
        Map<String, Object> newAccountsMap = null;
        newAccountsMap = existedAccountMap == null ? new LinkedHashMap<String, Object>() : existedAccountMap;
        if (StringUtils.isEmpty((CharSequence)plainAccessConfig.getAccessKey()) || plainAccessConfig.getAccessKey().length() <= 6) {
            throw new AclException(String.format("The accessKey=%s cannot be null and length should longer than 6", plainAccessConfig.getAccessKey()));
        }
        newAccountsMap.put("accessKey", plainAccessConfig.getAccessKey());
        if (!StringUtils.isEmpty((CharSequence)plainAccessConfig.getSecretKey())) {
            if (plainAccessConfig.getSecretKey().length() <= 6) {
                throw new AclException(String.format("The secretKey=%s value length should longer than 6", plainAccessConfig.getSecretKey()));
            }
            newAccountsMap.put("secretKey", plainAccessConfig.getSecretKey());
        }
        if (plainAccessConfig.getWhiteRemoteAddress() != null) {
            newAccountsMap.put("whiteRemoteAddress", plainAccessConfig.getWhiteRemoteAddress());
        }
        if (!StringUtils.isEmpty((CharSequence)String.valueOf(plainAccessConfig.isAdmin()))) {
            newAccountsMap.put("admin", plainAccessConfig.isAdmin());
        }
        if (!StringUtils.isEmpty((CharSequence)plainAccessConfig.getDefaultTopicPerm())) {
            newAccountsMap.put("defaultTopicPerm", plainAccessConfig.getDefaultTopicPerm());
        }
        if (!StringUtils.isEmpty((CharSequence)plainAccessConfig.getDefaultGroupPerm())) {
            newAccountsMap.put("defaultGroupPerm", plainAccessConfig.getDefaultGroupPerm());
        }
        if (plainAccessConfig.getTopicPerms() != null) {
            newAccountsMap.put("topicPerms", plainAccessConfig.getTopicPerms());
        }
        if (plainAccessConfig.getGroupPerms() != null) {
            newAccountsMap.put("groupPerms", plainAccessConfig.getGroupPerms());
        }
        return newAccountsMap;
    }

    public boolean deleteAccessConfig(String accesskey) {
        if (StringUtils.isEmpty((CharSequence)accesskey)) {
            log.error("Parameter value accesskey is null or empty String,Please check your parameter");
            return false;
        }
        if (this.accessKeyTable.containsKey(accesskey)) {
            String aclFileName = this.accessKeyTable.get(accesskey);
            Map aclAccessConfigMap = AclUtils.getYamlDataObject(aclFileName, Map.class);
            if (aclAccessConfigMap == null || aclAccessConfigMap.isEmpty()) {
                throw new AclException(String.format("the %s file is not found or empty", aclFileName));
            }
            List accounts = (List)aclAccessConfigMap.get("accounts");
            Iterator itemIterator = accounts.iterator();
            while (itemIterator.hasNext()) {
                if (!((Map)itemIterator.next()).get("accessKey").equals(accesskey)) continue;
                itemIterator.remove();
                aclAccessConfigMap.put("accounts", accounts);
                return AclUtils.writeDataObject(aclFileName, this.updateAclConfigFileVersion(aclAccessConfigMap));
            }
        }
        return false;
    }

    public boolean updateGlobalWhiteAddrsConfig(List<String> globalWhiteAddrsList) {
        if (globalWhiteAddrsList == null) {
            log.error("Parameter value globalWhiteAddrsList is null,Please check your parameter");
            return false;
        }
        Map aclAccessConfigMap = AclUtils.getYamlDataObject(this.defaultAclFile, Map.class);
        if (aclAccessConfigMap == null || aclAccessConfigMap.isEmpty()) {
            throw new AclException(String.format("the %s file is not found or empty", this.defaultAclFile));
        }
        List globalWhiteRemoteAddrList = (List)aclAccessConfigMap.get("globalWhiteRemoteAddresses");
        if (globalWhiteRemoteAddrList != null) {
            globalWhiteRemoteAddrList.clear();
            if (globalWhiteAddrsList != null) {
                globalWhiteRemoteAddrList.addAll(globalWhiteAddrsList);
            }
            aclAccessConfigMap.put("globalWhiteRemoteAddresses", globalWhiteRemoteAddrList);
            return AclUtils.writeDataObject(this.defaultAclFile, this.updateAclConfigFileVersion(aclAccessConfigMap));
        }
        log.error("Users must ensure that the acl yaml config file has globalWhiteRemoteAddresses flag in the {} firstly", (Object)this.defaultAclFile);
        return false;
    }

    public boolean updateGlobalWhiteAddrsConfig(List<String> globalWhiteAddrsList, String fileName) {
        if (globalWhiteAddrsList == null) {
            log.error("Parameter value globalWhiteAddrsList is null,Please check your parameter");
            return false;
        }
        File file = new File(fileName);
        if (!file.exists() || file.isDirectory()) {
            log.error("Parameter value fileName is not exist or is a directory,Please check your parameter");
            return false;
        }
        Map aclAccessConfigMap = AclUtils.getYamlDataObject(fileName, Map.class);
        if (aclAccessConfigMap == null || aclAccessConfigMap.isEmpty()) {
            throw new AclException(String.format("the %s file is not found or empty", fileName));
        }
        List globalWhiteRemoteAddrList = (List)aclAccessConfigMap.get("globalWhiteRemoteAddresses");
        if (globalWhiteRemoteAddrList != null) {
            globalWhiteRemoteAddrList.clear();
            if (globalWhiteAddrsList != null) {
                globalWhiteRemoteAddrList.addAll(globalWhiteAddrsList);
            }
            aclAccessConfigMap.put("globalWhiteRemoteAddresses", globalWhiteRemoteAddrList);
            return AclUtils.writeDataObject(fileName, this.updateAclConfigFileVersion(aclAccessConfigMap));
        }
        log.error("Users must ensure that the acl yaml config file has globalWhiteRemoteAddresses flag in the {} firstly", (Object)fileName);
        return false;
    }

    public AclConfig getAllAclConfig() {
        AclConfig aclConfig = new AclConfig();
        ArrayList<PlainAccessConfig> configs = new ArrayList<PlainAccessConfig>();
        ArrayList whiteAddrs = new ArrayList();
        HashSet<String> accessKeySets = new HashSet<String>();
        for (int i = 0; i < this.fileList.size(); ++i) {
            JSONArray accounts;
            String path = this.fileList.get(i);
            JSONObject plainAclConfData = AclUtils.getYamlDataObject(path, JSONObject.class);
            if (plainAclConfData == null || plainAclConfData.isEmpty()) {
                throw new AclException(String.format("%s file is not data", path));
            }
            JSONArray globalWhiteAddrs = plainAclConfData.getJSONArray("globalWhiteRemoteAddresses");
            if (globalWhiteAddrs != null && !globalWhiteAddrs.isEmpty()) {
                whiteAddrs.addAll(globalWhiteAddrs.toJavaList(String.class));
            }
            if ((accounts = plainAclConfData.getJSONArray("accounts")) == null || accounts.isEmpty()) continue;
            List plainAccessConfigs = accounts.toJavaList(PlainAccessConfig.class);
            for (int j = 0; j < plainAccessConfigs.size(); ++j) {
                if (accessKeySets.contains(((PlainAccessConfig)plainAccessConfigs.get(j)).getAccessKey())) continue;
                accessKeySets.add(((PlainAccessConfig)plainAccessConfigs.get(j)).getAccessKey());
                PlainAccessConfig plainAccessConfig = new PlainAccessConfig();
                plainAccessConfig.setGroupPerms(((PlainAccessConfig)plainAccessConfigs.get(j)).getGroupPerms());
                plainAccessConfig.setDefaultTopicPerm(((PlainAccessConfig)plainAccessConfigs.get(j)).getDefaultTopicPerm());
                plainAccessConfig.setDefaultGroupPerm(((PlainAccessConfig)plainAccessConfigs.get(j)).getDefaultGroupPerm());
                plainAccessConfig.setAccessKey(((PlainAccessConfig)plainAccessConfigs.get(j)).getAccessKey());
                plainAccessConfig.setSecretKey(((PlainAccessConfig)plainAccessConfigs.get(j)).getSecretKey());
                plainAccessConfig.setAdmin(((PlainAccessConfig)plainAccessConfigs.get(j)).isAdmin());
                plainAccessConfig.setTopicPerms(((PlainAccessConfig)plainAccessConfigs.get(j)).getTopicPerms());
                plainAccessConfig.setWhiteRemoteAddress(((PlainAccessConfig)plainAccessConfigs.get(j)).getWhiteRemoteAddress());
                configs.add(plainAccessConfig);
            }
        }
        aclConfig.setPlainAccessConfigs(configs);
        aclConfig.setGlobalWhiteAddrs(whiteAddrs);
        return aclConfig;
    }

    private void watch() {
        try {
            AclFileWatchService aclFileWatchService = new AclFileWatchService(this.defaultAclDir, this.defaultAclFile, new AclFileWatchService.Listener(){

                public void onFileChanged(String aclFileName) {
                    PlainPermissionManager.this.load(aclFileName);
                }

                public void onFileNumChanged(String path) {
                    PlainPermissionManager.this.load();
                }
            });
            aclFileWatchService.start();
            log.info("Succeed to start AclFileWatchService");
            this.isWatchStart = true;
        }
        catch (Exception e) {
            log.error("Failed to start AclWatcherService", (Throwable)e);
        }
    }

    void checkPerm(PlainAccessResource needCheckedAccess, PlainAccessResource ownedAccess) {
        if (Permission.needAdminPerm(needCheckedAccess.getRequestCode()) && !ownedAccess.isAdmin()) {
            throw new AclException(String.format("Need admin permission for request code=%d, but accessKey=%s is not", needCheckedAccess.getRequestCode(), ownedAccess.getAccessKey()));
        }
        Map<String, Byte> needCheckedPermMap = needCheckedAccess.getResourcePermMap();
        Map<String, Byte> ownedPermMap = ownedAccess.getResourcePermMap();
        if (needCheckedPermMap == null) {
            return;
        }
        if (ownedPermMap == null && ownedAccess.isAdmin()) {
            return;
        }
        for (Map.Entry<String, Byte> needCheckedEntry : needCheckedPermMap.entrySet()) {
            String resource = needCheckedEntry.getKey();
            Byte neededPerm = needCheckedEntry.getValue();
            boolean isGroup = PlainAccessResource.isRetryTopic(resource);
            if (ownedPermMap == null || !ownedPermMap.containsKey(resource)) {
                byte ownedPerm;
                byte by = ownedPerm = isGroup ? ownedAccess.getDefaultGroupPerm() : ownedAccess.getDefaultTopicPerm();
                if (Permission.checkPermission(neededPerm, ownedPerm)) continue;
                throw new AclException(String.format("No default permission for %s", PlainAccessResource.printStr(resource, isGroup)));
            }
            if (Permission.checkPermission(neededPerm, ownedPermMap.get(resource))) continue;
            throw new AclException(String.format("No default permission for %s", PlainAccessResource.printStr(resource, isGroup)));
        }
    }

    void clearPermissionInfo() {
        this.aclPlainAccessResourceMap.clear();
        this.accessKeyTable.clear();
        this.globalWhiteRemoteAddressStrategy.clear();
    }

    public void checkPlainAccessConfig(PlainAccessConfig plainAccessConfig) throws AclException {
        if (plainAccessConfig.getAccessKey() == null || plainAccessConfig.getSecretKey() == null || plainAccessConfig.getAccessKey().length() <= 6 || plainAccessConfig.getSecretKey().length() <= 6) {
            throw new AclException(String.format("The accessKey=%s and secretKey=%s cannot be null and length should longer than 6", plainAccessConfig.getAccessKey(), plainAccessConfig.getSecretKey()));
        }
    }

    public PlainAccessResource buildPlainAccessResource(PlainAccessConfig plainAccessConfig) throws AclException {
        this.checkPlainAccessConfig(plainAccessConfig);
        PlainAccessResource plainAccessResource = new PlainAccessResource();
        plainAccessResource.setAccessKey(plainAccessConfig.getAccessKey());
        plainAccessResource.setSecretKey(plainAccessConfig.getSecretKey());
        plainAccessResource.setWhiteRemoteAddress(plainAccessConfig.getWhiteRemoteAddress());
        plainAccessResource.setAdmin(plainAccessConfig.isAdmin());
        plainAccessResource.setDefaultGroupPerm(Permission.parsePermFromString(plainAccessConfig.getDefaultGroupPerm()));
        plainAccessResource.setDefaultTopicPerm(Permission.parsePermFromString(plainAccessConfig.getDefaultTopicPerm()));
        Permission.parseResourcePerms(plainAccessResource, false, plainAccessConfig.getGroupPerms());
        Permission.parseResourcePerms(plainAccessResource, true, plainAccessConfig.getTopicPerms());
        plainAccessResource.setRemoteAddressStrategy(this.remoteAddressStrategyFactory.getRemoteAddressStrategy(plainAccessResource.getWhiteRemoteAddress()));
        return plainAccessResource;
    }

    public void validate(PlainAccessResource plainAccessResource) {
        for (RemoteAddressStrategy remoteAddressStrategy : this.globalWhiteRemoteAddressStrategy) {
            if (!remoteAddressStrategy.match(plainAccessResource)) continue;
            return;
        }
        if (plainAccessResource.getAccessKey() == null) {
            throw new AclException(String.format("No accessKey is configured", new Object[0]));
        }
        if (!this.accessKeyTable.containsKey(plainAccessResource.getAccessKey())) {
            throw new AclException(String.format("No acl config for %s", plainAccessResource.getAccessKey()));
        }
        String aclFileName = this.accessKeyTable.get(plainAccessResource.getAccessKey());
        PlainAccessResource ownedAccess = this.aclPlainAccessResourceMap.get(aclFileName).get(plainAccessResource.getAccessKey());
        if (ownedAccess.getRemoteAddressStrategy().match(plainAccessResource)) {
            return;
        }
        String signature = AclUtils.calSignature(plainAccessResource.getContent(), ownedAccess.getSecretKey());
        if (!signature.equals(plainAccessResource.getSignature())) {
            throw new AclException(String.format("Check signature failed for accessKey=%s", plainAccessResource.getAccessKey()));
        }
        this.checkPerm(plainAccessResource, ownedAccess);
    }

    public boolean isWatchStart() {
        return this.isWatchStart;
    }
}

