/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.meta;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.mqtt.common.facade.MetaPersistManager;
import org.apache.rocketmq.mqtt.common.util.TopicUtils;
import org.apache.rocketmq.mqtt.ds.config.ServiceConf;
import org.apache.rocketmq.mqtt.ds.mq.MqFactory;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaPersistManagerSample
implements MetaPersistManager {
    private static Logger logger = LoggerFactory.getLogger(MetaPersistManagerSample.class);
    private volatile Map<String, Set<String>> wildcardCache = new ConcurrentHashMap<String, Set<String>>();
    private volatile Set<String> firstTopics = new HashSet<String>();
    private volatile Set<String> connectNodeSet = new HashSet<String>();
    private DefaultMQAdminExt defaultMQAdminExt;
    private ScheduledThreadPoolExecutor scheduler;
    private static final String RMQ_NAMESPACE = "LMQ";
    private static final String KEY_LMQ_ALL_FIRST_TOPICS = "ALL_FIRST_TOPICS";
    private static final String KEY_LMQ_CONNECT_NODES = "LMQ_CONNECT_NODES";
    private static final String VALUE_SPLITTER = ",";
    @Resource
    private ServiceConf serviceConf;

    public void init() throws MQClientException, RemotingException, InterruptedException {
        this.defaultMQAdminExt = MqFactory.buildDefaultMQAdminExt("MetaLoad", this.serviceConf.getProperties());
        this.defaultMQAdminExt.start();
        this.refreshMeta();
        this.scheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ThreadFactoryImpl("refreshMeta"));
        this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.refreshMeta();
            }
            catch (Throwable t) {
                logger.error("", t);
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    private void refreshMeta() throws RemotingException, InterruptedException, MQClientException {
        String value = this.defaultMQAdminExt.getKVConfig(RMQ_NAMESPACE, KEY_LMQ_ALL_FIRST_TOPICS);
        if (value == null) {
            return;
        }
        String[] topics = value.split(VALUE_SPLITTER);
        HashSet<String> tmpFirstTopics = new HashSet<String>();
        ConcurrentHashMap<String, Set<String>> tmpWildcardCache = new ConcurrentHashMap<String, Set<String>>();
        for (String topic : topics) {
            tmpFirstTopics.add(topic);
            try {
                String wildcardValue = this.defaultMQAdminExt.getKVConfig(RMQ_NAMESPACE, topic);
                String[] wildcards = wildcardValue.split(VALUE_SPLITTER);
                HashSet<String> tmpWildcards = new HashSet<String>();
                for (String wildcard : wildcards) {
                    tmpWildcards.add(TopicUtils.normalizeTopic((String)wildcard));
                }
                tmpWildcardCache.put(topic, tmpWildcards);
            }
            catch (MQClientException e) {
                if (22 == e.getResponseCode()) continue;
                throw e;
            }
        }
        this.firstTopics = tmpFirstTopics;
        this.wildcardCache = tmpWildcardCache;
        value = this.defaultMQAdminExt.getKVConfig(RMQ_NAMESPACE, KEY_LMQ_CONNECT_NODES);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String[] ss = StringUtils.split((String)value, (String)VALUE_SPLITTER);
            HashSet<String> set = new HashSet<String>();
            for (String s : ss) {
                set.add(s);
            }
            this.connectNodeSet = set;
        }
    }

    public Set<String> getWildcards(String firstTopic) {
        return this.wildcardCache.get(firstTopic);
    }

    public Set<String> getAllFirstTopics() {
        return this.firstTopics;
    }

    public Set<String> getConnectNodeSet() {
        return this.connectNodeSet;
    }
}

