/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.starter;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.rocketmq.mqtt.cs.channel.ConnectHandler;
import org.apache.rocketmq.mqtt.cs.config.ConnectConf;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.MqttPacketDispatcher;
import org.apache.rocketmq.mqtt.cs.protocol.ssl.SslFactory;
import org.apache.rocketmq.mqtt.cs.protocol.ws.WebSocketEncoder;
import org.apache.rocketmq.mqtt.cs.protocol.ws.WebSocketServerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MqttServer {
    private static Logger logger = LoggerFactory.getLogger(MqttServer.class);
    private ServerBootstrap serverBootstrap = new ServerBootstrap();
    private ServerBootstrap wsServerBootstrap = new ServerBootstrap();
    private ServerBootstrap tlsServerBootstrap = new ServerBootstrap();
    @Resource
    private ConnectHandler connectHandler;
    @Resource
    private ConnectConf connectConf;
    @Resource
    private MqttPacketDispatcher mqttPacketDispatcher;
    @Resource
    private WebSocketServerHandler webSocketServerHandler;
    @Resource
    private SslFactory sslFactory;

    @PostConstruct
    public void init() throws Exception {
        this.start();
        this.startWs();
        this.startTls();
    }

    private void start() {
        int port = this.connectConf.getMqttPort();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group((EventLoopGroup)new NioEventLoopGroup(this.connectConf.getNettySelectorThreadNum()), (EventLoopGroup)new NioEventLoopGroup(this.connectConf.getNettyWorkerThreadNum())).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)8192)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.connectConf.getLowWater(), this.connectConf.getHighWater())).childOption(ChannelOption.TCP_NODELAY, (Object)true).localAddress((SocketAddress)new InetSocketAddress(port))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("connectHandler", (ChannelHandler)MqttServer.this.connectHandler);
                pipeline.addLast("decoder", (ChannelHandler)new MqttDecoder(MqttServer.this.connectConf.getMaxPacketSizeInByte()));
                pipeline.addLast("encoder", (ChannelHandler)MqttEncoder.INSTANCE);
                pipeline.addLast("dispatcher", (ChannelHandler)MqttServer.this.mqttPacketDispatcher);
            }
        });
        this.serverBootstrap.bind();
        logger.warn("start mqtt server , port:{}", (Object)port);
    }

    private void startTls() {
        if (!this.connectConf.isEnableTlsSever()) {
            return;
        }
        int tlsPort = this.connectConf.getMqttTlsPort();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.tlsServerBootstrap.group((EventLoopGroup)new NioEventLoopGroup(this.connectConf.getNettySelectorThreadNum()), (EventLoopGroup)new NioEventLoopGroup(this.connectConf.getNettyWorkerThreadNum())).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)8192)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.connectConf.getLowWater(), this.connectConf.getHighWater())).childOption(ChannelOption.TCP_NODELAY, (Object)true).localAddress((SocketAddress)new InetSocketAddress(tlsPort))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("sslHandler", (ChannelHandler)new SslHandler(MqttServer.this.sslFactory.buildSslEngine(ch)));
                pipeline.addLast("connectHandler", (ChannelHandler)MqttServer.this.connectHandler);
                pipeline.addLast("decoder", (ChannelHandler)new MqttDecoder(MqttServer.this.connectConf.getMaxPacketSizeInByte()));
                pipeline.addLast("encoder", (ChannelHandler)MqttEncoder.INSTANCE);
                pipeline.addLast("dispatcher", (ChannelHandler)MqttServer.this.mqttPacketDispatcher);
            }
        });
        this.tlsServerBootstrap.bind();
        logger.warn("start mqtt tls server , port:{}", (Object)tlsPort);
    }

    private void startWs() {
        int port = this.connectConf.getMqttWsPort();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.wsServerBootstrap.group((EventLoopGroup)new NioEventLoopGroup(this.connectConf.getNettySelectorThreadNum()), (EventLoopGroup)new NioEventLoopGroup(this.connectConf.getNettyWorkerThreadNum())).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)8192)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.connectConf.getLowWater(), this.connectConf.getHighWater())).childOption(ChannelOption.TCP_NODELAY, (Object)true).localAddress((SocketAddress)new InetSocketAddress(port))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("connectHandler", (ChannelHandler)MqttServer.this.connectHandler);
                pipeline.addLast("http-codec", (ChannelHandler)new HttpServerCodec(1024, 32768, MqttServer.this.connectConf.getMaxPacketSizeInByte() * 2, true));
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(MqttServer.this.connectConf.getMaxPacketSizeInByte() * 2));
                pipeline.addLast("http-chunked", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast("websocket-handler", (ChannelHandler)MqttServer.this.webSocketServerHandler);
                pipeline.addLast("websocket-encoder", (ChannelHandler)new WebSocketEncoder());
                pipeline.addLast("decoder", (ChannelHandler)new MqttDecoder(MqttServer.this.connectConf.getMaxPacketSizeInByte()));
                pipeline.addLast("encoder", (ChannelHandler)MqttEncoder.INSTANCE);
                pipeline.addLast("dispatcher", (ChannelHandler)MqttServer.this.mqttPacketDispatcher);
            }
        });
        this.wsServerBootstrap.bind();
        logger.warn("start mqtt ws server , port:{}", (Object)port);
    }
}

