/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.protocol.mqtt.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import javax.annotation.Resource;
import org.apache.rocketmq.mqtt.common.hook.HookResult;
import org.apache.rocketmq.mqtt.cs.channel.ChannelInfo;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.MqttPacketHandler;
import org.apache.rocketmq.mqtt.cs.session.infly.RetryDriver;
import org.springframework.stereotype.Component;

@Component
public class MqttPubRecHandler
implements MqttPacketHandler<MqttMessage> {
    private final MqttFixedHeader pubRelMqttFixedHeader = new MqttFixedHeader(MqttMessageType.PUBREL, false, MqttQoS.AT_LEAST_ONCE, false, 0);
    @Resource
    private RetryDriver retryDriver;

    @Override
    public boolean preHandler(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        return true;
    }

    @Override
    public void doHandler(ChannelHandlerContext ctx, MqttMessage mqttMessage, HookResult upstreamHookResult) {
        MqttMessageIdVariableHeader variableHeader = (MqttMessageIdVariableHeader)mqttMessage.variableHeader();
        String channelId = ChannelInfo.getId(ctx.channel());
        this.retryDriver.unMountPublish(variableHeader.messageId(), channelId);
        this.retryDriver.mountPubRel(variableHeader.messageId(), channelId);
        MqttMessage pubRelMqttMessage = new MqttMessage(this.pubRelMqttFixedHeader, (Object)variableHeader);
        ctx.channel().writeAndFlush((Object)pubRelMqttMessage);
    }
}

