/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util.concurrent;

import com.alipay.sofa.jraft.util.Ints;
import com.alipay.sofa.jraft.util.concurrent.ExecutorChooserFactory;
import com.alipay.sofa.jraft.util.concurrent.SingleThreadExecutor;
import java.util.concurrent.atomic.AtomicInteger;

public final class DefaultExecutorChooserFactory
implements ExecutorChooserFactory {
    public static final DefaultExecutorChooserFactory INSTANCE = new DefaultExecutorChooserFactory();

    @Override
    public ExecutorChooserFactory.ExecutorChooser newChooser(SingleThreadExecutor[] executors) {
        if (Ints.isPowerOfTwo(executors.length)) {
            return new PowerOfTwoExecutorChooser(executors);
        }
        return new GenericExecutorChooser(executors);
    }

    private DefaultExecutorChooserFactory() {
    }

    private static abstract class AbstractExecutorChooser
    implements ExecutorChooserFactory.ExecutorChooser {
        protected final AtomicInteger idx = new AtomicInteger();
        protected final SingleThreadExecutor[] executors;

        protected AbstractExecutorChooser(SingleThreadExecutor[] executors) {
            this.executors = executors;
        }

        @Override
        public SingleThreadExecutor next() {
            return this.select(this.idx.getAndIncrement());
        }
    }

    private static class GenericExecutorChooser
    extends AbstractExecutorChooser {
        protected GenericExecutorChooser(SingleThreadExecutor[] executors) {
            super(executors);
        }

        @Override
        public SingleThreadExecutor select(int index) {
            return this.executors[Math.abs(index % this.executors.length)];
        }
    }

    private static class PowerOfTwoExecutorChooser
    extends AbstractExecutorChooser {
        PowerOfTwoExecutorChooser(SingleThreadExecutor[] executors) {
            super(executors);
        }

        @Override
        public SingleThreadExecutor select(int index) {
            return this.executors[index & this.executors.length - 1];
        }
    }
}

