/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.v2.producer;

import apache.rocketmq.v2.Code;
import apache.rocketmq.v2.RecallMessageRequest;
import apache.rocketmq.v2.RecallMessageResponse;
import apache.rocketmq.v2.Resource;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.grpc.v2.AbstractMessagingActivity;
import org.apache.rocketmq.proxy.grpc.v2.channel.GrpcChannelManager;
import org.apache.rocketmq.proxy.grpc.v2.common.GrpcClientSettingsManager;
import org.apache.rocketmq.proxy.grpc.v2.common.ResponseBuilder;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;

public class RecallMessageActivity
extends AbstractMessagingActivity {
    public RecallMessageActivity(MessagingProcessor messagingProcessor, GrpcClientSettingsManager grpcClientSettingsManager, GrpcChannelManager grpcChannelManager) {
        super(messagingProcessor, grpcClientSettingsManager, grpcChannelManager);
    }

    public CompletableFuture<RecallMessageResponse> recallMessage(ProxyContext ctx, RecallMessageRequest request) {
        CompletionStage<Object> future = new CompletableFuture<RecallMessageResponse>();
        try {
            Resource topic = request.getTopic();
            this.validateTopic(topic);
            future = this.messagingProcessor.recallMessage(ctx, topic.getName(), request.getRecallHandle(), Duration.ofSeconds(2L).toMillis()).thenApply(result -> RecallMessageResponse.newBuilder().setMessageId(result).setStatus(ResponseBuilder.getInstance().buildStatus(Code.OK, Code.OK.name())).build());
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }
}

