/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util;

import java.security.AccessController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemPropertyUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SystemPropertyUtil.class);

    public static boolean contains(String key) {
        return SystemPropertyUtil.get(key) != null;
    }

    public static String get(String key) {
        return SystemPropertyUtil.get(key, null);
    }

    public static String get(String key, String def) {
        String value;
        block5: {
            if (key == null) {
                throw new NullPointerException("key");
            }
            if (key.isEmpty()) {
                throw new IllegalArgumentException("key must not be empty.");
            }
            value = null;
            try {
                value = System.getSecurityManager() == null ? System.getProperty(key) : AccessController.doPrivileged(() -> System.getProperty(key));
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block5;
                LOG.warn("Unable to retrieve a system property '{}'; default values will be used, {}.", (Object)key, (Object)e);
            }
        }
        if (value == null) {
            return def;
        }
        return value;
    }

    public static boolean getBoolean(String key, boolean def) {
        String value = SystemPropertyUtil.get(key);
        if (value == null) {
            return def;
        }
        if ((value = value.trim().toLowerCase()).isEmpty()) {
            return true;
        }
        if ("true".equals(value) || "yes".equals(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "no".equals(value) || "0".equals(value)) {
            return false;
        }
        LOG.warn("Unable to parse the boolean system property '{}':{} - using the default value: {}.", new Object[]{key, value, def});
        return def;
    }

    public static int getInt(String key, int def) {
        String value = SystemPropertyUtil.get(key);
        if (value == null) {
            return def;
        }
        value = value.trim().toLowerCase();
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            LOG.warn("Unable to parse the integer system property '{}':{} - using the default value: {}.", new Object[]{key, value, def});
            return def;
        }
    }

    public static long getLong(String key, long def) {
        String value = SystemPropertyUtil.get(key);
        if (value == null) {
            return def;
        }
        value = value.trim().toLowerCase();
        try {
            return Long.parseLong(value);
        }
        catch (Exception exception) {
            LOG.warn("Unable to parse the long system property '{}':{} - using the default value: {}.", new Object[]{key, value, def});
            return def;
        }
    }

    public static Object setProperty(String key, String value) {
        return System.getProperties().setProperty(key, value);
    }

    private SystemPropertyUtil() {
    }
}

