/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.route;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.mqclient.MQClientAPIFactory;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.thread.ThreadPoolMonitor;
import org.apache.rocketmq.common.utils.AbstractStartAndShutdown;
import org.apache.rocketmq.common.utils.StartAndShutdown;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.AbstractCacheLoader;
import org.apache.rocketmq.proxy.common.Address;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.service.route.AddressableMessageQueue;
import org.apache.rocketmq.proxy.service.route.MessageQueueView;
import org.apache.rocketmq.proxy.service.route.ProxyTopicRouteData;
import org.apache.rocketmq.proxy.service.route.TopicRouteHelper;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class TopicRouteService
extends AbstractStartAndShutdown {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private final MQClientAPIFactory mqClientAPIFactory;
    protected final LoadingCache<String, MessageQueueView> topicCache;
    protected final ScheduledExecutorService scheduledExecutorService;
    protected final ThreadPoolExecutor cacheRefreshExecutor;
    private final TopicRouteCacheLoader topicRouteCacheLoader = new TopicRouteCacheLoader();

    public TopicRouteService(MQClientAPIFactory mqClientAPIFactory) {
        ProxyConfig config = ConfigurationManager.getProxyConfig();
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("TopicRouteService_"));
        this.cacheRefreshExecutor = ThreadPoolMonitor.createAndMonitor((int)config.getTopicRouteServiceThreadPoolNums(), (int)config.getTopicRouteServiceThreadPoolNums(), (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS, (String)"TopicRouteCacheRefresh", (int)config.getTopicRouteServiceThreadPoolQueueCapacity());
        this.mqClientAPIFactory = mqClientAPIFactory;
        this.topicCache = Caffeine.newBuilder().maximumSize((long)config.getTopicRouteServiceCacheMaxNum()).refreshAfterWrite((long)config.getTopicRouteServiceCacheExpiredInSeconds(), TimeUnit.SECONDS).executor((Executor)this.cacheRefreshExecutor).build((CacheLoader)new CacheLoader<String, MessageQueueView>(){

            public @Nullable MessageQueueView load(String topic) throws Exception {
                try {
                    TopicRouteData topicRouteData = TopicRouteService.this.topicRouteCacheLoader.loadTopicRouteData(topic);
                    if (TopicRouteService.isTopicRouteValid(topicRouteData)) {
                        MessageQueueView tmp = new MessageQueueView(topic, topicRouteData);
                        log.info("load topic route from namesrv. topic: {}, queue: {}", (Object)topic, (Object)tmp);
                        return tmp;
                    }
                    return MessageQueueView.WRAPPED_EMPTY_QUEUE;
                }
                catch (Exception e) {
                    if (TopicRouteHelper.isTopicNotExistError(e)) {
                        return MessageQueueView.WRAPPED_EMPTY_QUEUE;
                    }
                    throw e;
                }
            }

            public @Nullable MessageQueueView reload(@NonNull String key, @NonNull MessageQueueView oldValue) throws Exception {
                try {
                    return this.load(key);
                }
                catch (Exception e) {
                    log.warn(String.format("reload topic route from namesrv. topic: %s", key), (Throwable)e);
                    return oldValue;
                }
            }
        });
        this.init();
    }

    protected void init() {
        this.appendShutdown(this.scheduledExecutorService::shutdown);
        this.appendStartAndShutdown((StartAndShutdown)this.mqClientAPIFactory);
    }

    public MessageQueueView getAllMessageQueueView(String topicName) throws Exception {
        return TopicRouteService.getCacheMessageQueueWrapper(this.topicCache, topicName);
    }

    public abstract MessageQueueView getCurrentMessageQueueView(String var1) throws Exception;

    public abstract ProxyTopicRouteData getTopicRouteForProxy(List<Address> var1, String var2) throws Exception;

    public abstract String getBrokerAddr(String var1) throws Exception;

    public abstract AddressableMessageQueue buildAddressableMessageQueue(MessageQueue var1) throws Exception;

    protected static MessageQueueView getCacheMessageQueueWrapper(LoadingCache<String, MessageQueueView> topicCache, String key) throws Exception {
        MessageQueueView res = (MessageQueueView)topicCache.get((Object)key);
        if (res != null && res.isEmptyCachedQueue()) {
            throw new MQClientException(17, "No topic route info in name server for the topic: " + key);
        }
        return res;
    }

    protected static boolean isTopicRouteValid(TopicRouteData routeData) {
        return routeData != null && routeData.getQueueDatas() != null && !routeData.getQueueDatas().isEmpty() && routeData.getBrokerDatas() != null && !routeData.getBrokerDatas().isEmpty();
    }

    protected class TopicRouteCacheLoader
    extends AbstractTopicRouteCacheLoader {
        protected TopicRouteCacheLoader() {
        }

        @Override
        protected TopicRouteData loadTopicRouteData(String topic) throws Exception {
            return TopicRouteService.this.mqClientAPIFactory.getClient().getTopicRouteInfoFromNameServer(topic, Duration.ofSeconds(3L).toMillis());
        }
    }

    protected abstract class AbstractTopicRouteCacheLoader
    extends AbstractCacheLoader<String, MessageQueueView> {
        public AbstractTopicRouteCacheLoader() {
            super(TopicRouteService.this.cacheRefreshExecutor);
        }

        protected abstract TopicRouteData loadTopicRouteData(String var1) throws Exception;

        @Override
        public MessageQueueView getDirectly(String topic) throws Exception {
            try {
                TopicRouteData topicRouteData = this.loadTopicRouteData(topic);
                if (TopicRouteService.isTopicRouteValid(topicRouteData)) {
                    MessageQueueView tmp = new MessageQueueView(topic, topicRouteData);
                    log.info("load topic route from namesrv. topic: {}, queue: {}", (Object)topic, (Object)tmp);
                    return tmp;
                }
                return MessageQueueView.WRAPPED_EMPTY_QUEUE;
            }
            catch (Exception e) {
                if (TopicRouteHelper.isTopicNotExistError(e)) {
                    return MessageQueueView.WRAPPED_EMPTY_QUEUE;
                }
                throw e;
            }
        }

        @Override
        protected void onErr(String key, Exception e) {
            log.error("load topic route from namesrv failed. topic:{}", (Object)key, (Object)e);
        }
    }
}

