/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.v2.consumer;

import apache.rocketmq.v2.AckMessageEntry;
import apache.rocketmq.v2.AckMessageRequest;
import apache.rocketmq.v2.AckMessageResponse;
import apache.rocketmq.v2.AckMessageResultEntry;
import apache.rocketmq.v2.Code;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.client.consumer.AckResult;
import org.apache.rocketmq.client.consumer.AckStatus;
import org.apache.rocketmq.common.consumer.ReceiptHandle;
import org.apache.rocketmq.proxy.common.MessageReceiptHandle;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.grpc.v2.AbstractMessingActivity;
import org.apache.rocketmq.proxy.grpc.v2.channel.GrpcChannelManager;
import org.apache.rocketmq.proxy.grpc.v2.common.GrpcClientSettingsManager;
import org.apache.rocketmq.proxy.grpc.v2.common.GrpcConverter;
import org.apache.rocketmq.proxy.grpc.v2.common.ResponseBuilder;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;
import org.apache.rocketmq.proxy.processor.ReceiptHandleProcessor;

public class AckMessageActivity
extends AbstractMessingActivity {
    protected ReceiptHandleProcessor receiptHandleProcessor;

    public AckMessageActivity(MessagingProcessor messagingProcessor, ReceiptHandleProcessor receiptHandleProcessor, GrpcClientSettingsManager grpcClientSettingsManager, GrpcChannelManager grpcChannelManager) {
        super(messagingProcessor, grpcClientSettingsManager, grpcChannelManager);
        this.receiptHandleProcessor = receiptHandleProcessor;
    }

    public CompletableFuture<AckMessageResponse> ackMessage(ProxyContext ctx, AckMessageRequest request) {
        CompletableFuture<AckMessageResponse> future = new CompletableFuture<AckMessageResponse>();
        try {
            this.validateTopicAndConsumerGroup(request.getTopic(), request.getGroup());
            CompletableFuture[] futures = new CompletableFuture[request.getEntriesCount()];
            for (int i = 0; i < request.getEntriesCount(); ++i) {
                futures[i] = this.processAckMessage(ctx, request, request.getEntries(i));
            }
            CompletableFuture.allOf(futures).whenComplete((val, throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally((Throwable)throwable);
                    return;
                }
                HashSet<Code> responseCodes = new HashSet<Code>();
                ArrayList<AckMessageResultEntry> entryList = new ArrayList<AckMessageResultEntry>();
                for (CompletableFuture entryFuture : futures) {
                    AckMessageResultEntry entryResult = (AckMessageResultEntry)entryFuture.join();
                    responseCodes.add(entryResult.getStatus().getCode());
                    entryList.add(entryResult);
                }
                AckMessageResponse.Builder responseBuilder = AckMessageResponse.newBuilder().addAllEntries(entryList);
                if (responseCodes.size() > 1) {
                    responseBuilder.setStatus(ResponseBuilder.getInstance().buildStatus(Code.MULTIPLE_RESULTS, Code.MULTIPLE_RESULTS.name()));
                } else if (responseCodes.size() == 1) {
                    Code code = (Code)responseCodes.stream().findAny().get();
                    responseBuilder.setStatus(ResponseBuilder.getInstance().buildStatus(code, code.name()));
                } else {
                    responseBuilder.setStatus(ResponseBuilder.getInstance().buildStatus(Code.INTERNAL_SERVER_ERROR, "ack message result is empty"));
                }
                future.complete(responseBuilder.build());
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    protected CompletableFuture<AckMessageResultEntry> processAckMessage(ProxyContext ctx, AckMessageRequest request, AckMessageEntry ackMessageEntry) {
        CompletableFuture<AckMessageResultEntry> future = new CompletableFuture<AckMessageResultEntry>();
        try {
            String handleString = ackMessageEntry.getReceiptHandle();
            String group = GrpcConverter.getInstance().wrapResourceWithNamespace(request.getGroup());
            MessageReceiptHandle messageReceiptHandle = this.receiptHandleProcessor.removeReceiptHandle((Channel)this.grpcChannelManager.getChannel(ctx.getClientID()), group, ackMessageEntry.getMessageId(), ackMessageEntry.getReceiptHandle());
            if (messageReceiptHandle != null) {
                handleString = messageReceiptHandle.getReceiptHandleStr();
            }
            CompletableFuture<AckResult> ackResultFuture = this.messagingProcessor.ackMessage(ctx, ReceiptHandle.decode((String)handleString), ackMessageEntry.getMessageId(), group, GrpcConverter.getInstance().wrapResourceWithNamespace(request.getTopic()));
            ((CompletableFuture)ackResultFuture.thenAccept(result -> future.complete(this.convertToAckMessageResultEntry(ctx, ackMessageEntry, (AckResult)result)))).exceptionally(t -> {
                future.complete(this.convertToAckMessageResultEntry(ctx, ackMessageEntry, (Throwable)t));
                return null;
            });
        }
        catch (Throwable t2) {
            future.complete(this.convertToAckMessageResultEntry(ctx, ackMessageEntry, t2));
        }
        return future;
    }

    protected AckMessageResultEntry convertToAckMessageResultEntry(ProxyContext ctx, AckMessageEntry ackMessageEntry, Throwable throwable) {
        return AckMessageResultEntry.newBuilder().setStatus(ResponseBuilder.getInstance().buildStatus(throwable)).setMessageId(ackMessageEntry.getMessageId()).setReceiptHandle(ackMessageEntry.getReceiptHandle()).build();
    }

    protected AckMessageResultEntry convertToAckMessageResultEntry(ProxyContext ctx, AckMessageEntry ackMessageEntry, AckResult ackResult) {
        if (AckStatus.OK.equals((Object)ackResult.getStatus())) {
            return AckMessageResultEntry.newBuilder().setMessageId(ackMessageEntry.getMessageId()).setReceiptHandle(ackMessageEntry.getReceiptHandle()).setStatus(ResponseBuilder.getInstance().buildStatus(Code.OK, Code.OK.name())).build();
        }
        return AckMessageResultEntry.newBuilder().setMessageId(ackMessageEntry.getMessageId()).setReceiptHandle(ackMessageEntry.getReceiptHandle()).setStatus(ResponseBuilder.getInstance().buildStatus(Code.INTERNAL_SERVER_ERROR, "ack failed: status is abnormal")).build();
    }
}

