/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.server.tomcat;

import java.util.concurrent.Executor;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.AbstractProtocol;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;

public class EmbeddedServerMetricsCollector {
    private final Connector connector;
    private final AbstractProtocol protocolHandler;

    EmbeddedServerMetricsCollector(Tomcat server) {
        this.connector = server.getConnector();
        this.protocolHandler = (AbstractProtocol)this.connector.getProtocolHandler();
    }

    public long getMaxAllowedConnection() {
        return this.protocolHandler.getMaxConnections();
    }

    public int getConnectionAcceptCount() {
        return this.protocolHandler.getAcceptCount();
    }

    public long getActiveConnectionCount() {
        return this.protocolHandler.getConnectionCount();
    }

    public int getMaxContainerThreadsCount() {
        return this.protocolHandler.getMaxThreads();
    }

    public int getMinSpareContainerThreadsCount() {
        return this.protocolHandler.getMinSpareThreads();
    }

    public int getActiveContainerThreadsCount() {
        Executor executor = this.protocolHandler.getExecutor();
        int activeThreadCount = -1;
        if (executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
            activeThreadCount = threadPoolExecutor.getActiveCount();
        }
        return activeThreadCount;
    }

    public int getTotalContainerThreadsCount() {
        Executor executor = this.protocolHandler.getExecutor();
        int totalThreadCount = -1;
        if (executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
            totalThreadCount = threadPoolExecutor.getPoolSize();
        }
        return totalThreadCount;
    }

    public String getProtocolHandlerName() {
        return this.protocolHandler.getName();
    }

    public long getConnectionTimeout() {
        return this.protocolHandler.getConnectionTimeout();
    }

    public long getKeepAliveTimeout() {
        return this.protocolHandler.getKeepAliveTimeout();
    }
}

