/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.hadoop.util.WeakReferenceMap;

public class WeakReferenceThreadMap<V>
extends WeakReferenceMap<Long, V> {
    public WeakReferenceThreadMap(Function<? super Long, ? extends V> factory, @Nullable Consumer<? super Long> referenceLost) {
        super(factory, referenceLost);
    }

    public V getForCurrentThread() {
        return this.get(this.currentThreadId());
    }

    public V removeForCurrentThread() {
        return this.remove(this.currentThreadId());
    }

    public long currentThreadId() {
        return Thread.currentThread().getId();
    }

    public V setForCurrentThread(V newVal) {
        Objects.requireNonNull(newVal);
        long id = this.currentThreadId();
        WeakReference existingWeakRef = this.lookup(id);
        if (this.resolve(existingWeakRef) == newVal) {
            return newVal;
        }
        return this.put(id, newVal);
    }
}

