/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.message.JmsMessage;
import org.apache.qpid.jms.message.facade.JmsBytesMessageFacade;

public class JmsBytesMessage
extends JmsMessage
implements BytesMessage {
    protected transient DataOutputStream dataOut;
    protected transient DataInputStream dataIn;
    private final JmsBytesMessageFacade facade;

    public JmsBytesMessage(JmsBytesMessageFacade facade) {
        super(facade);
        this.facade = facade;
    }

    @Override
    public JmsBytesMessage copy() throws JMSException {
        JmsBytesMessage other = new JmsBytesMessage(this.facade.copy());
        other.copy(this);
        return other;
    }

    private void copy(JmsBytesMessage other) throws JMSException {
        super.copy(other);
        this.dataOut = null;
        this.dataIn = null;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.dataOut = null;
        this.dataIn = null;
    }

    public long getBodyLength() throws JMSException {
        this.initializeReading();
        return this.facade.getBodyLength();
    }

    public boolean readBoolean() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readBoolean();
        }
        catch (EOFException e) {
            throw JmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public byte readByte() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readByte();
        }
        catch (EOFException e) {
            throw JmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.create(e);
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readUnsignedByte();
        }
        catch (EOFException e) {
            throw JmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public short readShort() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readShort();
        }
        catch (EOFException e) {
            throw JmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readUnsignedShort();
        }
        catch (EOFException e) {
            throw JmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public char readChar() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readChar();
        }
        catch (EOFException e) {
            throw JmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public int readInt() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readInt();
        }
        catch (EOFException e) {
            throw JmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public long readLong() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readLong();
        }
        catch (EOFException e) {
            throw JmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public float readFloat() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readFloat();
        }
        catch (EOFException e) {
            throw JmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public double readDouble() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readDouble();
        }
        catch (EOFException e) {
            throw JmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public String readUTF() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readUTF();
        }
        catch (EOFException e) {
            throw JmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        return this.readBytes(value, value.length);
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        this.initializeReading();
        if (length < 0 || value.length < length) {
            throw new IndexOutOfBoundsException("length must not be negative or larger than the size of the provided array");
        }
        try {
            int n;
            int count;
            for (n = 0; n < length && (count = this.dataIn.read(value, n, length - n)) >= 0; n += count) {
            }
            if (n == 0 && length > 0) {
                n = -1;
            }
            return n;
        }
        catch (EOFException e) {
            throw JmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeBoolean(value);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeByte(value);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeShort(short value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeShort(value);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeChar(char value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeChar(value);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeInt(int value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeInt(value);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeLong(long value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeLong(value);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeFloat(value);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeDouble(value);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeUTF(String value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeUTF(value);
        }
        catch (IOException ioe) {
            throw JmsExceptionSupport.create(ioe);
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(value);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(value, offset, length);
        }
        catch (IOException e) {
            throw JmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (value == null) {
            throw new NullPointerException();
        }
        this.initializeWriting();
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeUTF(value.toString());
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new MessageFormatException("Cannot write non-primitive type:" + String.valueOf(value.getClass()));
        }
    }

    public void reset() throws JMSException {
        this.facade.reset();
        this.dataOut = null;
        this.dataIn = null;
        this.setReadOnlyBody(true);
    }

    @Override
    public void onSend(long producerTtl) throws JMSException {
        this.reset();
        super.onSend(producerTtl);
    }

    @Override
    public String toString() {
        return "JmsBytesMessage { " + String.valueOf(this.facade) + " }";
    }

    @Override
    public boolean isBodyAssignableTo(Class target) throws JMSException {
        return this.facade.hasBody() ? target.isAssignableFrom(byte[].class) : true;
    }

    @Override
    protected <T> T doGetBody(Class<T> asType) throws JMSException {
        this.reset();
        if (!this.facade.hasBody()) {
            return null;
        }
        return (T)this.facade.copyBody();
    }

    private void initializeWriting() throws JMSException {
        this.checkReadOnlyBody();
        if (this.dataOut == null) {
            this.dataOut = new DataOutputStream(this.facade.getOutputStream());
        }
    }

    private void initializeReading() throws JMSException {
        this.checkWriteOnlyBody();
        if (this.dataIn == null) {
            this.dataIn = new DataInputStream(this.facade.getInputStream());
        }
    }
}

